/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import plus.dragons.visuality.particle.type.ColorParticleType;

public class WaterCircleParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private static final Quaternionf QUATERNION = new Quaternionf(0.0f, -0.7f, 0.7f, 0.0f);

    private WaterCircleParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, SpriteSet sprites) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_107225_ = 5 + this.f_107223_.m_188503_(3);
        this.m_172260_(0.0, 0.0, 0.0);
        if (r > 0.0f && g > 0.0f && b > 0.0f) {
            this.m_107253_(r, g, b);
        }
        this.m_6569_(2.0f + (float)this.f_107223_.m_188503_(11) / 10.0f);
        this.sprites = sprites;
        this.m_108339_(sprites);
    }

    public void setColor(int rgbHex) {
        float red = (float)((rgbHex & 0xFF0000) >> 16) / 255.0f;
        float green = (float)((rgbHex & 0xFF00) >> 8) / 255.0f;
        float blue = (float)(rgbHex & 0xFF) / 255.0f;
        this.m_107253_(red, green, blue);
    }

    public void m_5989_() {
        if (this.f_107224_ > this.f_107225_ / 2) {
            this.m_107271_(1.0f - ((float)this.f_107224_ - (float)(this.f_107225_ / 2)) / (float)this.f_107225_);
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.sprites);
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float ticks) {
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)ticks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)ticks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)ticks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.m_5902_(ticks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vector3fs[i];
            vector3f.rotate((Quaternionfc)QUATERNION);
            vector3f.mul(f4);
            vector3f.add(x, y, z);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(ticks);
        buffer.m_5483_((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<ColorParticleType.Options>
    {
        public Particle createParticle(ColorParticleType.Options options, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            return new WaterCircleParticle(world, x, y, z, options.r, options.g, options.b, this.sprites);
        }
    }
}

