/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.data;

import javax.annotation.Nullable;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.fluid.transfer.AbstractFluidContainerTransferProvider;
import slimeknights.mantle.fluid.transfer.FillFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.fluids.item.EmptyPotionTransfer;
import slimeknights.tconstruct.shared.block.SlimeType;

public class FluidContainerTransferProvider
extends AbstractFluidContainerTransferProvider {
    public FluidContainerTransferProvider(PackOutput packOutput) {
        super(packOutput, "tconstruct");
    }

    protected void addTransfers() {
        this.addFillEmpty("honey_bottle_", (ItemLike)Items.f_42787_, (ItemLike)Items.f_42590_, (FluidObject)TinkerFluids.honey, 250, false, new ICondition[0]);
        this.addFillEmpty("beetroot_soup_", (ItemLike)Items.f_42734_, (ItemLike)Items.f_42399_, (FluidObject)TinkerFluids.beetrootSoup, 250, false, new ICondition[0]);
        this.addFillEmpty("mushroom_stew_", (ItemLike)Items.f_42400_, (ItemLike)Items.f_42399_, (FluidObject)TinkerFluids.mushroomStew, 250, false, new ICondition[0]);
        this.addFillEmpty("rabbit_stew_", (ItemLike)Items.f_42699_, (ItemLike)Items.f_42399_, (FluidObject)TinkerFluids.rabbitStew, 250, false, new ICondition[0]);
        this.addFillEmpty("meat_soup_", (ItemLike)TinkerFluids.meatSoupBowl, (ItemLike)Items.f_42399_, (FluidObject)TinkerFluids.meatSoup, 250, false, new ICondition[0]);
        this.addPotion("potion_", (ItemLike)Items.f_42589_, (ItemLike)Items.f_42590_, null);
        this.addPotion("potion_splash_", (ItemLike)Items.f_42736_, (ItemLike)TinkerFluids.splashBottle, TinkerTags.Items.SPLASH_BOTTLE);
        this.addPotion("potion_lingering_", (ItemLike)Items.f_42739_, (ItemLike)TinkerFluids.lingeringBottle, TinkerTags.Items.LINGERING_BOTTLE);
        this.addBottleFill("venom_bottle_fill", (ItemLike)TinkerFluids.venomBottle, (FluidObject<?>)TinkerFluids.venom);
        this.addBottleFill("earth_slime_bottle_fill", (ItemLike)TinkerFluids.slimeBottle.get((Enum)SlimeType.EARTH), (FluidObject<?>)TinkerFluids.earthSlime);
        this.addBottleFill("sky_slime_bottle_fill", (ItemLike)TinkerFluids.slimeBottle.get((Enum)SlimeType.SKY), (FluidObject<?>)TinkerFluids.skySlime);
        this.addBottleFill("ender_slime_bottle_fill", (ItemLike)TinkerFluids.slimeBottle.get((Enum)SlimeType.ENDER), (FluidObject<?>)TinkerFluids.enderSlime);
        this.addBottleFill("magma_bottle_fill", (ItemLike)TinkerFluids.magmaBottle, (FluidObject<?>)TinkerFluids.magma);
    }

    protected void addPotion(String prefix, ItemLike filled, ItemLike containerItem, @Nullable TagKey<Item> containerTag) {
        this.addTransfer(prefix + "empty", new EmptyPotionTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{filled}), ItemOutput.fromItem((ItemLike)containerItem), TinkerFluids.potion.result(250)), new ICondition[0]);
        Ingredient container = containerTag == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{containerItem}) : Ingredient.m_204132_(containerTag);
        this.addTransfer(prefix + "fill", (IFluidContainerTransfer)new FillFluidWithNBTTransfer(container, ItemOutput.fromItem((ItemLike)filled), TinkerFluids.potion.ingredient(250)), new ICondition[0]);
        this.addTransfer(prefix + "water", (IFluidContainerTransfer)new FillFluidContainerTransfer(container, ItemOutput.fromStack((ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack(filled), (Potion)Potions.f_43599_)), (FluidIngredient)FluidIngredient.of((TagKey)MantleTags.Fluids.WATER, (int)500)), new ICondition[0]);
    }

    protected void addBottleFill(String name, ItemLike output, FluidObject<?> fluid) {
        this.addTransfer(name, (IFluidContainerTransfer)new FillFluidContainerTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_}), ItemOutput.fromItem((ItemLike)output), fluid.ingredient(250)), new ICondition[0]);
    }

    public String m_6055_() {
        return "Tinkers' Construct Fluid Container Transfer";
    }
}

