/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.entity.controller.MelterBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiMeltingModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiTankModule;
import slimeknights.tconstruct.smeltery.menu.MelterContainerMenu;

public class MelterScreen
extends AbstractContainerScreen<MelterContainerMenu>
implements IScreenWithFluidTank {
    private static final ResourceLocation BACKGROUND = TConstruct.getResource("textures/gui/melter.png");
    private static final ElementScreen SCALA = new ElementScreen(BACKGROUND, 176, 0, 52, 52, 256, 256);
    private static final ElementScreen FUEL_SLOT = new ElementScreen(BACKGROUND, 176, 52, 18, 36, 256, 256);
    private static final ElementScreen FUEL_TANK = new ElementScreen(BACKGROUND, 194, 52, 14, 38, 256, 256);
    private final GuiMeltingModule melting;
    private final GuiFuelModule fuel;
    private final GuiTankModule tank;

    public MelterScreen(MelterContainerMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        MelterBlockEntity te = (MelterBlockEntity)container.getTile();
        if (te != null) {
            FuelModule fuelModule = te.getFuelModule();
            this.melting = new GuiMeltingModule(this, te.getMeltingInventory(), fuelModule::getTemperature, slot -> true, BACKGROUND);
            this.fuel = new GuiFuelModule(this, fuelModule, 153, 32, 12, 36, 152, 15, container.isHasFuelSlot(), BACKGROUND);
            this.tank = new GuiTankModule(this, (IFluidHandler)te.getTank(), 90, 16, 52, 52, MelterContainerMenu.TOOLTIP_FORMAT);
        } else {
            this.melting = null;
            this.fuel = null;
            this.tank = null;
        }
    }

    public void m_88315_(GuiGraphics graphics, int x, int y, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, x, y, partialTicks);
        this.m_280072_(graphics, x, y);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(graphics, this, BACKGROUND);
        if (this.fuel != null) {
            if (((MelterContainerMenu)this.f_97732_).isHasFuelSlot()) {
                FUEL_SLOT.draw(graphics, this.f_97735_ + 150, this.f_97736_ + 31);
            } else {
                FUEL_TANK.draw(graphics, this.f_97735_ + 152, this.f_97736_ + 31);
            }
            this.fuel.draw(graphics);
        }
        if (this.tank != null) {
            this.tank.draw(graphics);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        int checkX = mouseX - this.f_97735_;
        int checkY = mouseY - this.f_97736_;
        if (this.tank != null) {
            this.tank.highlightHoveredFluid(graphics, checkX, checkY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(graphics, checkX, checkY);
        }
        SCALA.draw(graphics, 90, 16);
        if (this.melting != null) {
            this.melting.drawHeatBars(graphics);
        }
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.renderTooltip(graphics, mouseX, mouseY);
        }
        if (this.melting != null) {
            this.melting.drawHeatTooltips(graphics, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.addTooltip(graphics, mouseX, mouseY, true);
        }
    }

    @Override
    public IScreenWithFluidTank.FluidLocation getFluidUnderMouse(int mouseX, int mouseY) {
        IScreenWithFluidTank.FluidLocation ingredient;
        int checkX = mouseX - this.f_97735_;
        int checkY = mouseY - this.f_97736_;
        if (this.fuel != null && (ingredient = this.fuel.getFluidUnderMouse(checkX, checkY)) != null) {
            return ingredient;
        }
        if (this.tank != null) {
            return this.tank.getFluidUnderMouse(checkX, checkY);
        }
        return null;
    }
}

