/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jsonthings;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.serializers.FlexItemType;
import dev.gigaherz.jsonthings.things.serializers.IItemSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraftforge.common.util.Lazy;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.item.armor.DummyArmorMaterial;
import slimeknights.tconstruct.library.tools.item.armor.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.item.armor.MultilayerArmorItem;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableBowItem;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableCrossbowItem;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexPartCastItem;
import slimeknights.tconstruct.tools.item.ModifiableSwordItem;
import slimeknights.tconstruct.tools.item.RepairKitItem;

public class FlexItemTypes {
    static final List<Item> TOOL_ITEMS = new ArrayList<Item>();
    static final List<Item> CROSSBOW_ITEMS = new ArrayList<Item>();
    static final List<Item> ARMOR_ITEMS = new ArrayList<Item>();

    private static <T> T add(List<? super T> list, T item) {
        list.add(item);
        return item;
    }

    public static void init() {
        FlexItemTypes.register("tool_part", data -> {
            MaterialStatsId statType = new MaterialStatsId(JsonHelper.getResourceLocation((JsonObject)data, (String)"stat_type"));
            return (props, builder) -> new ToolPartItem(props, statType);
        });
        FlexItemTypes.register("repair_kit", data -> {
            float repairAmount = GsonHelper.m_13915_((JsonObject)data, (String)"repair_amount");
            return (props, builder) -> new RepairKitItem(props, repairAmount);
        });
        FlexItemTypes.register("tool", data -> {
            boolean breakBlocksInCreative = GsonHelper.m_13855_((JsonObject)data, (String)"break_blocks_in_creative", (boolean)true);
            return (props, builder) -> {
                ToolDefinition definition = ToolDefinition.create(builder.getRegistryName());
                return FlexItemTypes.add(TOOL_ITEMS, breakBlocksInCreative ? new ModifiableItem(props, definition) : new ModifiableSwordItem(props, definition));
            };
        });
        FlexItemTypes.register("bow", data -> (props, builder) -> FlexItemTypes.add(TOOL_ITEMS, new ModifiableBowItem(props, ToolDefinition.create(builder.getRegistryName()))));
        FlexItemTypes.register("crossbow", data -> {
            boolean allowFireworks = GsonHelper.m_13912_((JsonObject)data, (String)"allow_fireworks");
            return (props, builder) -> FlexItemTypes.add(CROSSBOW_ITEMS, new ModifiableCrossbowItem(props, ToolDefinition.create(builder.getRegistryName()), allowFireworks ? ProjectileWeaponItem.f_43006_ : ProjectileWeaponItem.f_43005_));
        });
        FlexItemTypes.register("part_cast", data -> {
            ResourceLocation partId = JsonHelper.getResourceLocation((JsonObject)data, (String)"part");
            return (props, builder) -> new FlexPartCastItem(props, builder, (Supplier<Item>)Lazy.of(() -> (Item)Loadables.ITEM.fromKey(partId, "part")));
        });
        FlexItemTypes.register("basic_armor", data -> {
            ResourceLocation name = JsonHelper.getResourceLocation((JsonObject)data, (String)"texture_name");
            SoundEvent sound = (SoundEvent)Loadables.SOUND_EVENT.getOrDefault(data, "equip_sound", (Object)SoundEvents.f_11675_);
            ArmorItem.Type slot = (ArmorItem.Type)JsonHelper.getAsEnum((JsonObject)data, (String)"slot", ArmorItem.Type.class);
            return (props, builder) -> FlexItemTypes.add(ARMOR_ITEMS, new ModifiableArmorItem(new DummyArmorMaterial(name, sound), slot, props, ToolDefinition.create(builder.getRegistryName())));
        });
        Loadable ARMOR_TEXTURES = ArmorTextureSupplier.LOADER.list(1);
        FlexItemTypes.register("multilayer_armor", data -> {
            ResourceLocation name = JsonHelper.getResourceLocation((JsonObject)data, (String)"model_name");
            SoundEvent sound = (SoundEvent)Loadables.SOUND_EVENT.getOrDefault(data, "equip_sound", (Object)SoundEvents.f_11675_);
            ArmorItem.Type slot = (ArmorItem.Type)JsonHelper.getAsEnum((JsonObject)data, (String)"slot", ArmorItem.Type.class);
            return (props, builder) -> FlexItemTypes.add(ARMOR_ITEMS, new MultilayerArmorItem(new DummyArmorMaterial(name, sound), slot, props, ToolDefinition.create(builder.getRegistryName())));
        });
    }

    private static <T extends Item> void register(String name, IItemSerializer<T> factory) {
        FlexItemType.register((String)TConstruct.resourceString(name), factory);
    }
}

