/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.fluid.UpdateFluidEffectsPacket;
import slimeknights.tconstruct.library.utils.JsonUtils;

public class FluidEffectManager
extends SimpleJsonResourceReloadListener {
    public static final String FOLDER = "tinkering/fluid_effects";
    public static final FluidEffectManager INSTANCE = new FluidEffectManager();
    private List<FluidEffects> fluids = List.of();
    private final Map<Fluid, FluidEffects> cache = new ConcurrentHashMap<Fluid, FluidEffects>();
    private static final FluidEffects EMPTY = new FluidEffects((FluidIngredient)FluidIngredient.EMPTY, List.of(), List.of());
    private ICondition.IContext conditionContext = ICondition.IContext.EMPTY;
    private final Function<Fluid, FluidEffects> FIND_UNCACHED = fluid -> {
        for (FluidEffects recipe : this.fluids) {
            if (!recipe.matches((Fluid)fluid)) continue;
            return recipe;
        }
        return EMPTY;
    };

    private FluidEffectManager() {
        super(JsonHelper.DEFAULT_GSON, FOLDER);
    }

    public void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, AddReloadListenerEvent.class, this::addDataPackListeners);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, OnDatapackSyncEvent.class, e -> JsonUtils.syncPackets(e, new ISimplePacket[]{new UpdateFluidEffectsPacket(this.fluids)}));
    }

    private void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
        this.conditionContext = event.getConditionContext();
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        long time = System.nanoTime();
        this.fluids = splashList.entrySet().stream().map(entry -> this.loadFluid((ResourceLocation)entry.getKey(), (JsonElement)((JsonElement)entry.getValue()).getAsJsonObject())).filter(Objects::nonNull).toList();
        this.cache.clear();
        TConstruct.LOG.info("Loaded {} spilling fluids in {} ms", (Object)this.fluids.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    @Nullable
    private FluidEffects loadFluid(ResourceLocation key, JsonElement element) {
        try {
            JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)"fluid_effect");
            if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (ICondition.IContext)this.conditionContext)) {
                return null;
            }
            return (FluidEffects)FluidEffects.LOADABLE.deserialize(json);
        }
        catch (JsonSyntaxException e) {
            TConstruct.LOG.error("Failed to load fluid effect {}", (Object)key, (Object)e);
            return null;
        }
    }

    void updateFromServer(List<FluidEffects> fluids) {
        this.fluids = fluids;
        this.cache.clear();
    }

    public FluidEffects find(Fluid fluid) {
        return this.cache.computeIfAbsent(fluid, this.FIND_UNCACHED);
    }
}

