/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;

public interface ConditionalFluidEffect<C extends FluidEffectContext>
extends FluidEffect<C> {
    public FluidEffect<? super C> effect();

    public boolean canApply(C var1);

    @Override
    default public float apply(FluidStack fluid, EffectLevel level, C context, IFluidHandler.FluidAction action) {
        return this.canApply(context) ? this.effect().apply(fluid, level, (FluidEffectContext)context, action) : 0.0f;
    }

    public record Entity(IJsonPredicate<LivingEntity> target, FluidEffect<? super FluidEffectContext.Entity> effect) implements ConditionalFluidEffect<FluidEffectContext.Entity>
    {
        public static final RecordLoadable<Entity> LOADER = RecordLoadable.create((RecordField)LivingEntityPredicate.LOADER.defaultField("target", e -> e.target), (RecordField)FluidEffect.ENTITY_EFFECTS.requiredField("effect", e -> e.effect), Entity::new);

        @Override
        public boolean canApply(FluidEffectContext.Entity context) {
            return TinkerPredicate.matches(this.target, context.getLivingTarget());
        }

        @Override
        public RecordLoadable<Entity> getLoader() {
            return LOADER;
        }
    }

    public record Block(IJsonPredicate<BlockState> block, FluidEffect<? super FluidEffectContext.Block> effect) implements ConditionalFluidEffect<FluidEffectContext.Block>
    {
        public static final RecordLoadable<Block> LOADER = RecordLoadable.create((RecordField)BlockPredicate.LOADER.defaultField("block", e -> e.block), (RecordField)FluidEffect.BLOCK_EFFECTS.requiredField("effect", e -> e.effect), Block::new);

        @Override
        public boolean canApply(FluidEffectContext.Block context) {
            return this.block.matches((Object)context.getBlockState());
        }

        @Override
        public RecordLoadable<Block> getLoader() {
            return LOADER;
        }
    }
}

