/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public abstract class AbstractEnchantmentToModifierProvider
extends GenericDataProvider {
    private final JsonObject enchantmentMap = new JsonObject();

    public AbstractEnchantmentToModifierProvider(PackOutput packOutput) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering");
    }

    protected abstract void addEnchantmentMappings();

    public CompletableFuture<?> m_213708_(CachedOutput pCache) {
        this.enchantmentMap.entrySet().clear();
        this.addEnchantmentMappings();
        return this.saveJson(pCache, TConstruct.getResource("enchantments_to_modifiers"), this.enchantmentMap);
    }

    private static String optionalId(ResourceLocation modifierId, boolean optional) {
        return optional ? modifierId.toString() + "?" : modifierId.toString();
    }

    protected void add(Enchantment enchantment, ModifierId modifierId) {
        this.add(enchantment, modifierId, false);
    }

    protected void add(Enchantment enchantment, ModifierId modifierId, boolean optionalModifier) {
        String key = Objects.requireNonNull(BuiltInRegistries.f_256876_.m_7981_((Object)enchantment)).toString();
        if (this.enchantmentMap.has(key) || this.enchantmentMap.has(key + "?")) {
            throw new IllegalArgumentException("Duplicate enchantment " + key);
        }
        this.enchantmentMap.addProperty(key, AbstractEnchantmentToModifierProvider.optionalId(modifierId, optionalModifier));
    }

    protected void addOptional(ResourceLocation enchantment, ModifierId modifierId, boolean optionalModifier) {
        String key = enchantment.toString();
        if (this.enchantmentMap.has(key) || this.enchantmentMap.has(key + "?")) {
            throw new IllegalArgumentException("Duplicate enchantment " + key);
        }
        this.enchantmentMap.addProperty(key + "?", AbstractEnchantmentToModifierProvider.optionalId(modifierId, optionalModifier));
    }

    protected void add(TagKey<Enchantment> tag, ModifierId modifierId) {
        this.add(tag, modifierId, false);
    }

    protected void add(TagKey<Enchantment> tag, ModifierId modifierId, boolean optionalModifier) {
        String key = "#" + tag.f_203868_();
        if (this.enchantmentMap.has(key)) {
            throw new IllegalArgumentException("Duplicate enchantment tag " + tag.f_203868_());
        }
        this.enchantmentMap.addProperty(key, AbstractEnchantmentToModifierProvider.optionalId(modifierId, optionalModifier));
    }

    protected void add(ResourceLocation tag, ModifierId modifierId) {
        this.add(tag, modifierId, false);
    }

    protected void add(ResourceLocation tag, ModifierId modifierId, boolean optionalModifier) {
        this.add((TagKey<Enchantment>)TagKey.m_203882_((ResourceKey)Registries.f_256762_, (ResourceLocation)tag), modifierId, optionalModifier);
    }
}

