/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.data.gen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.brnbrd.delightful.data.gen.DelightfulBlockLoot;
import net.brnbrd.delightful.data.gen.DelightfulBlockStateProvider;
import net.brnbrd.delightful.data.gen.DelightfulBlockTagProvider;
import net.brnbrd.delightful.data.gen.DelightfulEntityTagProvider;
import net.brnbrd.delightful.data.gen.DelightfulItemModelProvider;
import net.brnbrd.delightful.data.gen.DelightfulItemTagProvider;
import net.brnbrd.delightful.data.gen.DelightfulLanguageProvider;
import net.brnbrd.delightful.data.gen.DelightfulLootModifierProvider;
import net.brnbrd.delightful.data.gen.DelightfulRecipeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="delightful")
public class Generators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent e) {
        DataGenerator gen = e.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookup = e.getLookupProvider();
        ExistingFileHelper helper = e.getExistingFileHelper();
        gen.addProvider(e.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(DelightfulBlockLoot::new, LootContextParamSets.f_81421_))));
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)new DelightfulRecipeProvider(output));
        DelightfulBlockTagProvider blockTag = new DelightfulBlockTagProvider(output, lookup, helper);
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)blockTag);
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)new DelightfulItemTagProvider(output, lookup, blockTag.m_274426_(), helper));
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)new DelightfulEntityTagProvider(output, lookup, helper));
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)new DelightfulLootModifierProvider(output));
        e.getGenerator().addProvider(e.includeClient(), (DataProvider)new DelightfulBlockStateProvider(output, helper));
        e.getGenerator().addProvider(e.includeClient(), (DataProvider)new DelightfulItemModelProvider(output, helper));
        e.getGenerator().addProvider(e.includeClient(), (DataProvider)new DelightfulLanguageProvider(output));
    }
}

