/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item;

import java.util.List;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.IConfigured;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class DItem
extends Item
implements IConfigured {
    private final boolean hasFoodEffectTooltip;
    @Nullable
    private final TagKey<Item> dependencyTag;
    @Nullable
    private final TagKey<Item> emptyTag;

    public DItem(Item.Properties prop) {
        super(prop);
        this.hasFoodEffectTooltip = false;
        this.emptyTag = null;
        this.dependencyTag = null;
    }

    public DItem(Item.Properties properties, boolean hasFoodEffectTooltip) {
        super(properties);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.emptyTag = null;
        this.dependencyTag = null;
    }

    public DItem(Item.Properties properties, boolean hasFoodEffectTooltip, @NotNull TagKey<Item> dependencyTag) {
        super(properties);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.dependencyTag = dependencyTag;
        this.emptyTag = null;
    }

    public DItem(Item.Properties properties, boolean hasFoodEffectTooltip, @Nullable TagKey<Item> dependencyTag, @NotNull TagKey<Item> emptyTag) {
        super(properties);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.dependencyTag = dependencyTag;
        this.emptyTag = emptyTag;
    }

    public boolean isEmptyTag() {
        return Util.tagEmpty(this.emptyTag);
    }

    public boolean isDependencyTag() {
        if (this.dependencyTag == null) {
            return true;
        }
        return Util.tagPopulated(this.dependencyTag);
    }

    public boolean isTag() {
        return this.isEmptyTag() && this.isDependencyTag();
    }

    @Override
    public boolean enabled() {
        return this.isTag() && IConfigured.super.enabled();
    }

    @Override
    public boolean enabledText(List<Component> comps) {
        boolean enabledConfig = IConfigured.super.enabledText(comps);
        if (!this.isEmptyTag() && this.emptyTag != null) {
            comps.add((Component)Component.m_237115_((String)"tooltip.requires_empty_tag"));
            comps.add((Component)Component.m_237113_((String)this.emptyTag.f_203868_().toString()).m_130940_(ChatFormatting.UNDERLINE));
        }
        if (!this.isDependencyTag() && this.dependencyTag != null) {
            comps.add((Component)Component.m_237115_((String)"tooltip.requires_tag"));
            comps.add((Component)Component.m_237113_((String)this.dependencyTag.f_203868_().toString()).m_130940_(ChatFormatting.UNDERLINE));
        }
        return enabledConfig;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> comps, @NotNull TooltipFlag pIsAdvanced) {
        if (this.enabledText(comps)) {
            if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue() && this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, comps, (float)1.0f);
            }
            super.m_7373_(stack, level, comps, pIsAdvanced);
        }
    }
}

