/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.brnbrd.delightful.common.DelightfulConfig;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.common.item.IConfigured;
import net.brnbrd.delightful.compat.Mods;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final String LOADER = "forge";

    public static ResourceLocation rl(String modid, String path) {
        return new ResourceLocation(modid, path);
    }

    public static ResourceLocation rl(String separated) {
        return new ResourceLocation(separated);
    }

    public static TagKey<Item> it(String modid, String path) {
        return ItemTags.create((ResourceLocation)Util.rl(modid, path));
    }

    public static TagKey<EntityType<?>> et(String modid, String path) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Util.rl(modid, path));
    }

    public static boolean tagEmpty(@Nullable TagKey<Item> tag) {
        if (tag == null) {
            return true;
        }
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        return tags != null && (!tags.isKnownTagName(tag) || tags.getTag(tag).isEmpty());
    }

    public static boolean tagPopulated(@Nullable TagKey<Item> tag) {
        if (tag == null) {
            return true;
        }
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        return tags != null && tags.isKnownTagName(tag) && !tags.getTag(tag).isEmpty();
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, ItemStack addition) {
        before.add((Object)addition);
        return before.clone();
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, Item addition, int count) {
        return count < 1 ? before : Util.with(before, new ItemStack((ItemLike)addition, count));
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, Item addition, RandomSource rand, int min, int max) {
        return max <= min ? before : Util.with(before, addition, rand.m_216332_(min, max));
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, Item addition) {
        return Util.with(before, addition, 1);
    }

    @Nullable
    public static Item item(ResourceLocation rl) {
        return (Item)ForgeRegistries.ITEMS.getValue(rl);
    }

    @Nullable
    public static Item item(String modid, String path) {
        return Util.item(Util.rl(modid, path));
    }

    @NotNull
    public static Item item(ResourceLocation rl, @NotNull Item backup) {
        return ForgeRegistries.ITEMS.containsKey(rl) ? Objects.requireNonNull(Util.item(rl)) : backup;
    }

    @NotNull
    public static Item item(ResourceLocation rl, @NotNull Supplier<Item> backup) {
        return Util.item(rl, backup.get());
    }

    @Nullable
    public static Block block(String modid, String path) {
        return Util.block(Util.rl(modid, path));
    }

    @Nullable
    public static Block block(ResourceLocation rl) {
        return (Block)ForgeRegistries.BLOCKS.getValue(rl);
    }

    public static boolean effectExists(ResourceLocation effect) {
        return Mods.loaded(effect.m_135827_()) && ForgeRegistries.MOB_EFFECTS.containsKey(effect);
    }

    @Nullable
    public static MobEffect effect(String modid, String name, @Nullable MobEffect backup) {
        ResourceLocation effLocation = Util.rl(modid, name);
        return Util.effectExists(effLocation) ? (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effLocation) : backup;
    }

    public static void addEffect(LivingEntity entity, @Nullable MobEffect effect, int duration, int amp) {
        if (effect == null) {
            return;
        }
        entity.m_7292_(new MobEffectInstance(effect, duration, amp));
    }

    public static void addEffect(LivingEntity entity, String modid, String name, int duration, int amp, MobEffect ... backup) {
        MobEffect me;
        MobEffect mobEffect = me = backup.length >= 1 ? Util.effect(modid, name, backup[0]) : Util.effect(modid, name, null);
        if (me != null) {
            Util.addEffect(entity, me, duration, amp);
        }
    }

    public static ItemStack gs(RegistryObject<Item> r, int count) {
        return new ItemStack((ItemLike)r.get(), count);
    }

    public static ItemStack gs(RegistryObject<Item> r) {
        return Util.gs(r, 1);
    }

    public static String name(Item item) {
        return ForgeRegistries.ITEMS.containsValue((Object)item) ? Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).m_135815_() : "";
    }

    public static String name(Block block) {
        return ForgeRegistries.BLOCKS.containsValue((Object)block) ? Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_() : "";
    }

    public static String name(RegistryObject<?> reg) {
        return reg.getId().m_135815_();
    }

    public static Ingredient ing(Supplier<? extends ItemLike> i) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{i.get()});
    }

    public static ItemStack enchant(ItemStack stack, Enchantment enchantment, int level) {
        ItemStack enchanted = stack.m_41777_();
        enchanted.m_41663_(enchantment, level);
        return enchanted;
    }

    public static void dropOrGive(ItemStack stack, Level world, BlockPos drop, Player give) {
        if (((Boolean)DelightfulConfig.GIVE_SLICED_DIRECTLY.get()).booleanValue()) {
            ItemHandlerHelper.giveItemToPlayer((Player)give, (ItemStack)stack, (int)0);
        } else {
            Containers.m_18992_((Level)world, (double)drop.m_123341_(), (double)((float)drop.m_123342_() + 0.25f), (double)drop.m_123343_(), (ItemStack)stack);
        }
    }

    public static boolean hasTagString(ItemStack stack, String key, String value) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag != null && tag.m_128441_(key) && tag.m_128461_(key).equals(value);
        }
        return false;
    }

    public static boolean configEnabled(String item) {
        return DelightfulConfig.CONFIG.verify(item);
    }

    public static boolean configEnabled(Item item) {
        return Util.configEnabled(Util.name(item));
    }

    public static boolean enabled(Item item) {
        boolean bl;
        if (item instanceof IConfigured) {
            IConfigured conf = (IConfigured)item;
            bl = conf.enabled();
        } else {
            bl = Util.configEnabled(item);
        }
        return bl;
    }

    public static boolean enabled(RegistryObject<Item> item) {
        return Util.enabled((Item)item.get());
    }

    public static boolean enabled(String item) {
        List<Item> found = DelightfulItems.ITEMS.getEntries().stream().filter(reg -> Objects.equals(reg.getId(), Util.rl("delightful", item))).map(RegistryObject::get).toList();
        return found.isEmpty() ? Util.configEnabled(item) : Util.enabled(found.get(0));
    }
}

