/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.integration.jei.category.forge;

import com.chefmooon.ubesdelight.common.crafting.forge.BakingMatRecipeImpl;
import com.chefmooon.ubesdelight.common.crafting.ingredient.ChanceResult;
import com.chefmooon.ubesdelight.common.registry.forge.UbesDelightItemsImpl;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import com.chefmooon.ubesdelight.integration.jei.forge.UDRecipeTypesImpl;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BakingMatRecipeCategoryImpl
implements IRecipeCategory<BakingMatRecipeImpl> {
    private final IDrawable slotLarge;
    private final IDrawable slotChance;
    private final Component title = TextUtils.getTranslatable("rei.baking_mat", new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;

    public BakingMatRecipeCategoryImpl(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("ubesdelight", "textures/gui/emi/baking_mat.png");
        this.slotLarge = helper.createDrawable(backgroundImage, 0, 80, 18, 18);
        this.slotChance = helper.createDrawable(backgroundImage, 18, 80, 18, 18);
        this.background = helper.createDrawable(backgroundImage, 7, 9, 149, 56);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)UbesDelightItemsImpl.BAKING_MAT_BAMBOO.get()));
    }

    public RecipeType<BakingMatRecipeImpl> getRecipeType() {
        return UDRecipeTypesImpl.BAKING_MAT;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 151;
    }

    public int getHeight() {
        return 56;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BakingMatRecipeImpl recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> getIngredients = recipe.m_7527_();
        NonNullList<Ingredient> getProcessStages = recipe.getProcessStages();
        List<ItemStack> recipeOutputs = recipe.getMandatoryResults();
        List<ChanceResult> recipeChanceOutputs = recipe.getVariableResult();
        builder.addSlot(RecipeIngredientRole.CATALYST, 57, 1).addIngredients(recipe.getTool());
        for (int i = 0; i < getIngredients.size(); ++i) {
            Pair<Integer, Integer> slotLoc = BakingMatRecipeCategoryImpl.getInputItemOffset(19, 20, i);
            builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)slotLoc.getFirst()).intValue(), ((Integer)slotLoc.getSecond()).intValue()).addIngredients((Ingredient)getIngredients.get(i));
        }
        if (getProcessStages.size() > 0) {
            for (int j = 0; j < getProcessStages.size(); ++j) {
                builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 57 + j * 19, 39).addIngredients((Ingredient)getProcessStages.get(j));
            }
        }
        for (int k = 0; k < recipeOutputs.size(); ++k) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 78 + k * 19, 20).addItemStack(recipeOutputs.get(k));
        }
        for (int l = 0; l < recipeChanceOutputs.size(); ++l) {
            int index = l;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 78 + l * 19, 1).addItemStack(recipeChanceOutputs.get(l).stack())).addTooltipCallback((slotView, tooltip) -> {
                ChanceResult output = (ChanceResult)recipeChanceOutputs.get(index);
                float chance = output.chance();
                if (chance != 1.0f) {
                    tooltip.add(1, TextUtils.getTranslatable("rei.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).m_130940_(ChatFormatting.GOLD));
                }
            });
        }
    }

    public void draw(BakingMatRecipeImpl recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        NonNullList<Ingredient> recipeInputs = recipe.m_7527_();
        NonNullList<Ingredient> recipeProcessStages = recipe.getProcessStages();
        List<ChanceResult> recipeChanceOutputs = recipe.getVariableResult();
        List<ItemStack> recipeOutputs = recipe.getMandatoryResults();
        for (int i = 0; i < recipeInputs.size(); ++i) {
            Pair<Integer, Integer> slotLoc = BakingMatRecipeCategoryImpl.getInputItemOffset(18, 19, i);
            this.slotLarge.draw(guiGraphics, ((Integer)slotLoc.getFirst()).intValue(), ((Integer)slotLoc.getSecond()).intValue());
        }
        if (recipeProcessStages.size() > 0) {
            for (int j = 0; j < recipeProcessStages.size(); ++j) {
                this.slotLarge.draw(guiGraphics, 56 + j * 19, 38);
            }
        }
        for (int k = 0; k < recipeOutputs.size(); ++k) {
            this.slotLarge.draw(guiGraphics, 77 + k * 19, 19);
        }
        for (int l = 0; l < recipeChanceOutputs.size(); ++l) {
            this.slotChance.draw(guiGraphics, 77 + l * 19, 0);
        }
    }

    public static Pair<Integer, Integer> getInputItemOffset(int x, int y, int index) {
        int xOffset = 19;
        int yOffset = 19;
        ArrayList<Pair> listOfPairs = new ArrayList<Pair>(List.of(Pair.of((Object)x, (Object)y), Pair.of((Object)(x + 19), (Object)y), Pair.of((Object)(x - 19), (Object)y), Pair.of((Object)x, (Object)(y - 19)), Pair.of((Object)x, (Object)(y + 19)), Pair.of((Object)(x + 19), (Object)(y - 19)), Pair.of((Object)(x - 19), (Object)(y - 19)), Pair.of((Object)(x + 19), (Object)(y + 19)), Pair.of((Object)(x - 19), (Object)(y + 19))));
        return (Pair)listOfPairs.get(index);
    }
}

