/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.item;

import com.chefmooon.ubesdelight.common.Configuration;
import com.chefmooon.ubesdelight.common.block.GlassCupBlock;
import com.chefmooon.ubesdelight.common.item.UbesDelightBlockItem;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class UbesDelightDrinkableBlockItem
extends UbesDelightBlockItem {
    public UbesDelightDrinkableBlockItem(Block block, Item.Properties properties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip) {
        super(block, properties, hasFoodEffectTooltip, hasCustomTooltip);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        if (!level.f_46443_) {
            this.affectConsumer(stack, level, consumer);
        }
        ItemStack containerStack = new ItemStack((ItemLike)Objects.requireNonNull(stack.m_41720_().m_41469_()));
        if (stack.m_41614_()) {
            super.m_5922_(stack, level, consumer);
        } else {
            Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, stack);
            }
            if (player != null) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
        }
        if (stack.m_41619_()) {
            return containerStack;
        }
        if (consumer instanceof Player) {
            player = (Player)consumer;
            if (!((Player)consumer).m_150110_().f_35937_ && !player.m_150109_().m_36054_(containerStack)) {
                player.m_36176_(containerStack, false);
            }
        }
        return stack;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_40576_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        if (player == null || !player.m_6144_()) return InteractionResult.FAIL;
        BlockPlaceContext blockPlaceContext = this.m_7732_(context);
        if (blockPlaceContext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = this.m_5965_(blockPlaceContext);
        if (blockState == null) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        ItemStack itemStack = blockPlaceContext.m_43722_();
        BlockState blockState2 = level.m_8055_(blockPos);
        Block block = blockState2.m_60734_();
        if (!(block instanceof GlassCupBlock)) return super.m_40576_(context);
        GlassCupBlock glassCupBlock = (GlassCupBlock)block;
        if (!itemStack.m_150930_(glassCupBlock.servingItem.get())) return super.m_40576_(context);
        glassCupBlock.addServingFromHand(level, blockPos, blockState2, player, player.m_7655_());
        return InteractionResult.FAIL;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (Configuration.isFoodEffectTooltip()) {
            if (this.hasCustomTooltip) {
                tooltip.add((Component)TextUtils.getTranslatable("tooltip.glass_cup", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip(stack, tooltip, 1.0f);
            }
        }
    }
}

