/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.leaf_feast.base;

import com.chefmooon.ubesdelight.common.block.leaf_feast.base.LargeLeafFeastBlock;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.LeafFeastBlock;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.forge.BaseLeafFeastBlockImpl;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.registry.UbesDelightItems;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import com.chefmooon.ubesdelight.common.utility.ItemStackUtil;
import com.chefmooon.ubesdelight.common.utility.VoxelShapeUtil;
import com.mojang.datafixers.util.Pair;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseLeafFeastBlock
extends Block
implements LeafFeastBlock,
SimpleWaterloggedBlock {
    protected final VoxelShape[] CONNECT_SHAPES = VoxelShapeUtil.getRotatedShapes(NORTH_CONNECT_SHAPE);
    protected final VoxelShape[] TIP_SHAPES = VoxelShapeUtil.getRotatedShapes(LEAF_NORTH_TIP_SHAPE);
    protected final VoxelShape[] END_SHAPES = VoxelShapeUtil.getRotatedShapes(LEAF_NORTH_END_SHAPE);

    public BaseLeafFeastBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (level.m_5776_() && (heldItem.m_41619_() ? this.tryRemoveItem(state, level, pos, player, hand).m_19077_() : this.tryAddItem(state, level, pos, player, hand).m_19077_())) {
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41619_()) {
            return this.tryRemoveItem(state, level, pos, player, hand);
        }
        return this.tryAddItem(state, level, pos, player, hand);
    }

    protected InteractionResult tryAddItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!player.m_6144_() && this.addItem(heldItem, state, level, pos, player).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41614_()) {
            return BaseLeafFeastBlock.transformToUniversal(heldItem, state, level, pos, player);
        }
        return InteractionResult.PASS;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static InteractionResult transformToUniversal(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return BaseLeafFeastBlockImpl.transformToUniversal(itemStack, (BlockState)var1_1, (Level)var2_2, (BlockPos)var3_3, (Player)var4_4);
    }

    private InteractionResult addItem(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player) {
        Block block = BaseLeafFeastBlock.getLeafFeastBlock(itemStack);
        if (block != Blocks.f_50016_) {
            BlockState newState = (BlockState)this.getTransformState(block, state).m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(1));
            if (block instanceof LargeLeafFeastBlock && (state.m_61143_((Property)LEAF_FEAST_TYPE) == LeafFeastTypes.END || state.m_61143_((Property)LEAF_FEAST_TYPE) == LeafFeastTypes.TIP)) {
                newState = (BlockState)newState.m_61124_((Property)LEAF_FEAST_TYPE, (Comparable)((Object)LeafFeastTypes.MIDDLE));
            }
            if (level.m_7731_(pos, newState, 3)) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41620_(1);
                    ItemStack container = ItemStackUtil.getContainer(itemStack);
                    if (!container.m_41619_() && !player.m_150109_().m_36054_(container)) {
                        player.m_36176_(container, false);
                    }
                }
                this.playAddSound(level, pos);
                LeafFeastBlock.triggerInsertAdvancement(player);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void tryEat(ItemStack itemStack, Level level, BlockPos pos, Player player) {
        ItemStack container = ItemStackUtil.getContainer(itemStack);
        if (!container.m_41619_()) {
            BaseLeafFeastBlock.spawnContainer(level, pos, player.m_6350_().m_122424_(), container);
        }
        player.m_5584_(level, itemStack);
        LeafFeastBlock.triggerConsumeAdvancement(player);
    }

    public static void spawnContainer(Level level, BlockPos blockPos, Direction direction, ItemStack itemStack) {
        ItemEntity entity = new ItemEntity(level, (double)blockPos.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.2, (double)blockPos.m_123342_() + 0.2, (double)blockPos.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.2, itemStack.m_41777_());
        entity.m_20334_((double)((float)direction.m_122429_() * 0.2f), 0.0, (double)((float)direction.m_122431_() * 0.2f));
        level.m_7967_((Entity)entity);
    }

    public boolean addItemFromDispenser(ItemStack itemStack, ServerLevel level, BlockPos pos, BlockState state) {
        Block block = BaseLeafFeastBlock.getLeafFeastBlock(itemStack);
        if (block != null && block != Blocks.f_50016_ && level.m_7731_(pos, (BlockState)this.getTransformState(block, state).m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(1)), 3)) {
            this.playAddSound((Level)level, pos);
            return true;
        }
        return false;
    }

    public static Block getLeafFeastBlock(ItemStack itemStack) {
        if (itemStack.m_150930_(BuiltInRegistryUtil.getItem(UbesDelightItems.ENSAYMADA))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_ENSAYMADA);
        }
        if (itemStack.m_150930_(BuiltInRegistryUtil.getItem(UbesDelightItems.ENSAYMADA_UBE))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_ENSAYMADA_UBE);
        }
        if (itemStack.m_150930_(BuiltInRegistryUtil.getItem(UbesDelightItems.PANDESAL))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_PANDESAL);
        }
        if (itemStack.m_150930_(BuiltInRegistryUtil.getItem(UbesDelightItems.PANDESAL_UBE))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_PANDESAL_UBE);
        }
        if (itemStack.m_150930_(BuiltInRegistryUtil.getItem(UbesDelightItems.HOPIA_MUNGGO))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_HOPIA_MUNGGO);
        }
        if (itemStack.m_150930_(BuiltInRegistryUtil.getItem(UbesDelightItems.HOPIA_UBE))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_HOPIA_UBE);
        }
        if (itemStack.m_150930_(BuiltInRegistryUtil.getItem(UbesDelightItems.LUMPIA))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LUMPIA_FEAST);
        }
        if (itemStack.m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("farmersdelight", "cooked_rice")))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_COOKED_RICE);
        }
        if (itemStack.m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("farmersdelight", "fried_rice")))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_FRIED_RICE);
        }
        if (itemStack.m_150930_(BuiltInRegistryUtil.getItem(UbesDelightItems.SINANGAG))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_SINANGAG);
        }
        return Blocks.f_50016_;
    }

    protected InteractionResult tryRemoveItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        LeafFeastTypes leafFeastType = (LeafFeastTypes)((Object)state.m_61143_((Property)LEAF_FEAST_TYPE));
        return Shapes.m_83110_((VoxelShape)this.getConnectShape(leafFeastType, this.getConnectDirections(facing.m_122424_()), this.CONNECT_SHAPES), (VoxelShape)this.getBaseShape(leafFeastType, facing, this.TIP_SHAPES, this.END_SHAPES, LEAF_BASE_SHAPE));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        FluidState fluid = context.m_43725_().m_6425_(blockPos);
        Level blockGetter = context.m_43725_();
        BlockState originBlockState = blockGetter.m_8055_(blockPos);
        Direction facing = context.m_8125_();
        Pair connectDirections = this.getConnectDirections(facing.m_122424_());
        BlockState rightBlockState = blockGetter.m_8055_(blockPos.m_121945_((Direction)connectDirections.getSecond()));
        BlockState leftBlockState = blockGetter.m_8055_(blockPos.m_121945_((Direction)connectDirections.getFirst()));
        LeafFeastTypes leafFeastType = this.getLeafFeastType(this.placementConnectsTo(facing, leftBlockState), this.placementConnectsTo(facing, rightBlockState));
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Pair connectDirections;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction == (connectDirections = this.getConnectDirections(((Direction)state.m_61143_((Property)FACING)).m_122424_())).getFirst() || direction == connectDirections.getSecond()) {
            LeafFeastTypes leafFeastType = this.getLeafFeastType(this.connectsTo(state, level.m_8055_(pos.m_121945_((Direction)connectDirections.getFirst()))), this.connectsTo(state, level.m_8055_(pos.m_121945_((Direction)connectDirections.getSecond()))));
            if ((Integer)state.m_61143_((Property)SERVINGS) > 3) {
                if (leafFeastType == LeafFeastTypes.END || leafFeastType == LeafFeastTypes.TIP) {
                    return (BlockState)state.m_61124_((Property)LEAF_FEAST_TYPE, (Comparable)((Object)LeafFeastTypes.MIDDLE));
                }
                return (BlockState)state.m_61124_((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType));
            }
            return (BlockState)state.m_61124_((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType));
        }
        if (direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, SERVINGS, LEAF_FEAST_TYPE});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)level, pos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

