/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.entities.misc.ITargetableEntity;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeathEssenceEntity
extends ThrowableProjectile
implements ITargetableEntity {
    private float damage;
    private LivingEntity target;
    private static final EntityDataAccessor<Float> DIRECTION_CHOICE = SynchedEntityData.m_135353_(DeathEssenceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public DeathEssenceEntity(EntityType<? extends DeathEssenceEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.target == null) {
            return;
        }
        int segments = 10;
        double dx = (this.m_20185_() - this.f_19790_) / (double)segments;
        double dy = (this.m_20186_() - this.f_19791_) / (double)segments;
        double dz = (this.m_20189_() - this.f_19792_) / (double)segments;
        for (int i = 0; i < segments; ++i) {
            this.m_9236_().m_7106_(ParticleUtils.constructSimpleSpark(new Color(this.f_19796_.m_188503_(50), this.f_19796_.m_188503_(50), 200 + this.f_19796_.m_188503_(55)), 0.25f + this.damage * 0.05f, 20 + Math.round(this.damage * 0.025f), 0.9f), this.m_20185_() + dx * (double)i, this.m_20186_() + dy * (double)i, this.m_20189_() + dz * (double)i, -this.m_20184_().f_82479_ * 0.1 * Math.random(), -this.m_20184_().f_82480_ * 0.1 * Math.random(), -this.m_20184_().f_82481_ * 0.1 * Math.random());
        }
        this.moveTowardsTargetInArc((Entity)this.target);
        if (this.target.m_21224_()) {
            this.m_146870_();
        }
        if (this.m_20270_((Entity)this.target) <= 1.0f) {
            Level level = this.target.m_20193_();
            this.target.m_6469_(level.m_269111_().m_269264_(), this.damage);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void moveTowardsTargetInArc(Entity target) {
        Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_());
        Vec3 direction = targetPos.m_82546_(this.m_20182_()).m_82541_();
        this.m_20256_(this.m_20182_().m_82549_(direction.m_82549_(new Vec3((double)this.getDirectionChoice() * -direction.f_82481_, 0.0, (double)this.getDirectionChoice() * direction.f_82479_))).m_82546_(this.m_20182_()).m_82541_().m_82490_(this.m_20182_().m_82554_(targetPos) * (double)((float)this.f_19797_ * 0.005f)));
    }

    protected void m_5790_(EntityHitResult result) {
        LivingEntity entity;
        Entity entity2;
        if (this.target == null || !((entity2 = result.m_82443_()) instanceof LivingEntity) || (entity = (LivingEntity)entity2).m_20148_() != this.target.m_20148_()) {
            return;
        }
        entity.m_6469_(this.m_9236_().m_269111_().m_269264_(), this.damage);
        this.m_146870_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DIRECTION_CHOICE, (Object)Float.valueOf(0.0f));
    }

    public boolean m_20068_() {
        return true;
    }

    public float getDirectionChoice() {
        return ((Float)this.f_19804_.m_135370_(DIRECTION_CHOICE)).floatValue();
    }

    public void setDirectionChoice(float value) {
        this.f_19804_.m_135381_(DIRECTION_CHOICE, (Object)Float.valueOf(value));
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }
}

