/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.IRelicScreenProvider;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.BigAbilityCardWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.RerollActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.ResetActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.UpgradeActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.general.PointsPlateWidget;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class AbilityDescriptionScreen
extends Screen
implements IAutoScaledScreen,
IRelicScreenProvider {
    public final Screen screen;
    public final int container;
    public final int slot;
    public ItemStack stack;
    public final String ability;
    public int backgroundHeight = 256;
    public int backgroundWidth = 418;
    public UpgradeActionWidget upgradeButton;
    public RerollActionWidget rerollButton;
    public ResetActionWidget resetButton;

    public AbilityDescriptionScreen(Player player, int container, int slot, Screen screen, String ability) {
        super((Component)Component.m_237119_());
        this.container = container;
        this.slot = slot;
        this.screen = screen;
        this.ability = ability;
        this.stack = DescriptionUtils.gatherRelicStack(player, slot);
    }

    protected void m_7856_() {
        if (this.stack == null || !(this.stack.m_41720_() instanceof IRelicItem)) {
            return;
        }
        int x = (this.f_96543_ - this.backgroundWidth) / 2;
        int y = (this.f_96544_ - this.backgroundHeight) / 2;
        this.m_142416_((GuiEventListener)new BigAbilityCardWidget(x + 60, y + 47, this, this.ability));
        this.m_142416_((GuiEventListener)new PointsPlateWidget(x + 313, y + 57, this));
        this.upgradeButton = new UpgradeActionWidget(x + 288, y + 152, this, this.ability);
        this.rerollButton = new RerollActionWidget(x + 288, y + 170, this, this.ability);
        this.resetButton = new ResetActionWidget(x + 288, y + 188, this, this.ability);
        this.m_142416_((GuiEventListener)this.upgradeButton);
        this.m_142416_((GuiEventListener)this.rerollButton);
        this.m_142416_((GuiEventListener)this.resetButton);
    }

    public void m_86600_() {
        super.m_86600_();
        this.stack = DescriptionUtils.gatherRelicStack((Player)this.f_96541_.f_91074_, this.slot);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        IRelicItem relic;
        LocalPlayer player;
        block15: {
            block14: {
                Item item;
                super.m_280273_(guiGraphics);
                player = this.f_96541_.f_91074_;
                if (this.stack == null || !((item = this.stack.m_41720_()) instanceof IRelicItem)) break block14;
                relic = (IRelicItem)item;
                if (player != null) break block15;
            }
            return;
        }
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        int level = relic.getAbilityPoints(this.stack, this.ability);
        PoseStack poseStack = guiGraphics.m_280168_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DescriptionTextures.SPACE_BACKGROUND);
        int x = (this.f_96543_ - this.backgroundWidth) / 2;
        int y = (this.f_96544_ - this.backgroundHeight) / 2;
        int yOff = 0;
        int xOff = 0;
        RenderUtils.renderAnimatedTextureFromCenter(poseStack, (float)x + (float)this.backgroundWidth / 2.0f, (float)y + (float)this.backgroundHeight / 2.0f, 418.0f, 4096.0f, this.backgroundWidth, this.backgroundHeight, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2).frame(14, 2).frame(15, 2));
        ResourceLocation card = new ResourceLocation("relics", "textures/gui/description/cards/" + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + "/" + (String)relic.getAbilityData(this.ability).getIcon().apply((Object)this.f_96541_.f_91074_, (Object)this.stack, (Object)this.ability) + ".png");
        float color = (float)((double)1.05f + Math.sin((float)(player.f_19797_ + this.ability.length() * 10) * 0.2f) * (double)0.1f);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        guiGraphics.m_280411_(card, x + 67, y + 57, 34, 49, 0.0f, 0.0f, 22, 31, 22, 31);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(DescriptionTextures.ABILITY_BACKGROUND, x + 60, y + 47, 0.0f, 0.0f, 243, 77, 243, 77);
        poseStack.m_85836_();
        int quality = relic.getAbilityQuality(this.stack, this.ability);
        boolean isAliquot = quality % 2 == 1;
        int i = 0;
        while ((double)i < Math.floor((double)quality / 2.0)) {
            guiGraphics.m_280163_(DescriptionTextures.BIG_STAR_ACTIVE, x + xOff + 64, y + 110, 0.0f, 0.0f, 8, 7, 8, 7);
            xOff += 8;
            ++i;
        }
        if (isAliquot) {
            guiGraphics.m_280163_(DescriptionTextures.BIG_STAR_ACTIVE, x + xOff + 64, y + 110, 0.0f, 0.0f, 4, 7, 8, 7);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        MutableComponent pointsComponent = Component.m_237113_((String)String.valueOf(level)).m_130940_(ChatFormatting.BOLD);
        poseStack.m_85841_(0.75f, 0.75f, 1.0f);
        guiGraphics.m_280614_(this.f_96541_.f_91062_, (Component)pointsComponent, (int)(((float)x + 85.5f) * 1.33f - (float)this.f_96541_.f_91062_.m_92852_((FormattedText)pointsComponent) / 2.0f), (int)((float)(y + 51) * 1.33f), 16769656, true);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        guiGraphics.m_280614_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".ability." + this.ability)).m_130940_(ChatFormatting.BOLD), (int)((float)(x + 113) * 1.33f), (int)((float)(y + 66) * 1.33f), 6696723, false);
        yOff = 9;
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence line : this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".ability." + this.ability + ".description")), 340)) {
            guiGraphics.m_280649_(this.f_96541_.f_91062_, line, (x + 112) * 2, (y + 73) * 2 + yOff, 6696723, false);
            yOff += 9;
        }
        poseStack.m_85849_();
        guiGraphics.m_280163_(DescriptionTextures.STATS_BACKGROUND, x + 60, y + 133, 0.0f, 0.0f, 243, 88, 243, 88);
        AbilityData abilityData = relicData.getAbilities().getAbilities().get(this.ability);
        int maxLevel = abilityData.getMaxLevel();
        boolean isLocked = !relic.canUseAbility(this.stack, this.ability);
        boolean isHoveredUpgrade = !isLocked && this.upgradeButton.m_274382_();
        boolean isHoveredReroll = !isLocked && this.rerollButton.m_274382_();
        boolean isHoveredReset = !isLocked && this.resetButton.m_274382_();
        yOff = 0;
        for (String stat : relic.getAbilityInitialValues(this.stack, this.ability).keySet()) {
            StatData statData = relic.getStatData(this.ability, stat);
            if (statData == null) continue;
            MutableComponent cost = Component.m_237113_((String)String.valueOf(statData.getFormatValue().apply(relic.getAbilityValue(this.stack, this.ability, stat))));
            if (isHoveredUpgrade && level < maxLevel) {
                cost.m_130946_(" \u27a0 " + statData.getFormatValue().apply(relic.getAbilityValue(this.stack, this.ability, stat, level + 1)));
            }
            if (isHoveredReroll) {
                cost.m_130946_(" \u27a0 ").m_7220_((Component)Component.m_237113_((String)"X.XXX").m_130940_(ChatFormatting.OBFUSCATED));
            }
            if (isHoveredReset && level > 0) {
                cost.m_130946_(" \u27a0 " + statData.getFormatValue().apply(relic.getAbilityValue(this.stack, this.ability, stat, 0)));
            }
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            guiGraphics.m_280614_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".ability." + this.ability + ".stat." + stat + ".title")).m_130940_(ChatFormatting.BOLD), (x + 85) * 2, (y + yOff + 151) * 2, 6696723, false);
            guiGraphics.m_280614_(this.f_96541_.f_91062_, (Component)Component.m_237113_((String)"\u25cf ").m_7220_((Component)Component.m_237110_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".ability." + this.ability + ".stat." + stat + ".value"), (Object[])new Object[]{cost})), (x + 90) * 2, (y + yOff + 157) * 2, 6696723, false);
            poseStack.m_85849_();
            xOff = 0;
            for (int i2 = 0; i2 < 5; ++i2) {
                guiGraphics.m_280163_(DescriptionTextures.SMALL_STAR_HOLE, x + xOff + 254, y + yOff + 151, 0.0f, 0.0f, 4, 4, 4, 4);
                xOff += 5;
            }
            xOff = 0;
            int quality2 = relic.getStatQuality(this.stack, this.ability, stat);
            boolean isAliquot2 = quality2 % 2 == 1;
            int i3 = 0;
            while ((double)i3 < Math.floor((double)quality2 / 2.0)) {
                guiGraphics.m_280163_(DescriptionTextures.SMALL_STAR_ACTIVE, x + xOff + 254, y + yOff + 151, 0.0f, 0.0f, 4, 4, 4, 4);
                xOff += 5;
                ++i3;
            }
            if (isAliquot2) {
                guiGraphics.m_280163_(DescriptionTextures.SMALL_STAR_ACTIVE, x + xOff + 254, y + yOff + 151, 0.0f, 0.0f, 2, 4, 4, 4);
            }
            yOff += 14;
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.m_6702_()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).m_274382_() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)new RelicDescriptionScreen((Player)this.f_96541_.f_91074_, this.container, this.slot, this.screen));
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }

    @Override
    public int getContainer() {
        return this.container;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }
}

