/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.client.render.layer;

import com.google.common.collect.Maps;
import fabric.net.mca.MCA;
import fabric.net.mca.MCAClient;
import fabric.net.mca.client.model.CommonVillagerModel;
import fabric.net.mca.client.model.PlayerEntityExtendedModel;
import fabric.net.mca.client.model.VillagerEntityModelMCA;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;

public abstract class VillagerLayer<T extends class_1309, M extends class_572<T>>
extends class_3887<T, M> {
    private static final float[] DEFAULT_COLOR = new float[]{1.0f, 1.0f, 1.0f};
    private static final Map<String, class_2960> TEXTURE_CACHE = Maps.newHashMap();
    private static final Map<class_2960, Boolean> TEXTURE_EXIST_CACHE = Maps.newHashMap();
    public final M model;

    public VillagerLayer(class_3883<T, M> renderer, M model) {
        super(renderer);
        this.model = model;
    }

    @Nullable
    public class_2960 getSkin(T villager) {
        return null;
    }

    @Nullable
    protected class_2960 getOverlay(T villager) {
        return null;
    }

    public float[] getColor(T villager, float tickDelta) {
        return DEFAULT_COLOR;
    }

    protected boolean isTranslucent() {
        return false;
    }

    public void render(class_4587 transform, class_4597 provider, int light, T villager, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        CommonVillagerModel layer;
        class_310 client = class_310.method_1551();
        boolean glowing = client.method_27022(villager);
        if (villager.method_5767() && !glowing) {
            return;
        }
        if (CommonVillagerModel.getVillager(villager).hasCustomSkin()) {
            return;
        }
        if (villager instanceof class_1657 && !MCAClient.useVillagerRenderer(villager.method_5667())) {
            return;
        }
        M m = this.model;
        if (m instanceof VillagerEntityModelMCA) {
            layer = (VillagerEntityModelMCA)m;
            ((VillagerEntityModelMCA)layer).copyVisibility((class_572)this.method_17165());
        }
        if ((m = this.model) instanceof PlayerEntityExtendedModel) {
            layer = (PlayerEntityExtendedModel)m;
            ((PlayerEntityExtendedModel)layer).copyVisibility((class_572)this.method_17165());
        }
        ((class_572)this.method_17165()).method_2818(this.model);
        this.renderFinal(transform, provider, light, villager, tickDelta, glowing);
    }

    public void renderFinal(class_4587 transform, class_4597 provider, int light, T villager, float tickDelta, boolean glowing) {
        class_2960 overlay;
        int tint = class_922.method_23622(villager, (float)0.0f);
        class_2960 skin = this.getSkin(villager);
        if (this.canUse(skin)) {
            float[] color = this.getColor(villager, tickDelta);
            this.renderModel(transform, provider, light, this.model, color[0], color[1], color[2], skin, tint, glowing);
        }
        if (!Objects.equals(skin, overlay = this.getOverlay(villager)) && this.canUse(overlay)) {
            this.renderModel(transform, provider, light, this.model, 1.0f, 1.0f, 1.0f, overlay, tint, glowing);
        }
    }

    private void renderModel(class_4587 transform, class_4597 provider, int light, M model, float r, float g, float b, class_2960 texture, int overlay, boolean glowing) {
        if (!glowing) {
            class_4588 buffer = provider.getBuffer(this.isTranslucent() ? class_1921.method_23580((class_2960)texture) : class_1921.method_23578((class_2960)texture));
            model.method_2828(transform, buffer, light, overlay, r, g, b, 1.0f);
        } else if (!this.isTranslucent()) {
            class_4588 buffer = provider.getBuffer(class_1921.method_23287((class_2960)texture));
            model.method_2828(transform, buffer, light, overlay, r, g, b, 1.0f);
        }
    }

    public final boolean canUse(class_2960 texture) {
        return TEXTURE_EXIST_CACHE.computeIfAbsent(texture, s -> {
            if (texture != null && texture.method_12836().equals("immersive_library")) {
                return true;
            }
            return texture != null && class_310.method_1551().method_1478().method_14486(texture).isPresent();
        });
    }

    @Nullable
    protected final class_2960 cached(String name, Function<String, class_2960> supplier) {
        return TEXTURE_CACHE.computeIfAbsent(name, s -> {
            try {
                return (class_2960)supplier.apply((String)s);
            }
            catch (class_151 ignored) {
                return null;
            }
        });
    }

    static {
        TEXTURE_EXIST_CACHE.put(MCA.locate("temp"), true);
    }
}

