/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.betterarcheology.util;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.Pandarix.betterarcheology.BetterArcheologyConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FleeBlockGoal<T extends BlockEntity>
extends Goal {
    protected final PathfinderMob mob;
    private final double slowSpeed;
    private final double fastSpeed;
    @Nullable
    protected BlockEntity targetBlock;
    @Nullable
    protected Path fleePath;
    protected final PathNavigation pathNav;
    protected final PathNavigation fleeingEntityNavigation;
    protected final Class<T> classToFleeFrom;

    public FleeBlockGoal(PathfinderMob mob, Class<T> fleeFromType, double slowSpeed, double fastSpeed) {
        this.mob = mob;
        this.classToFleeFrom = fleeFromType;
        this.slowSpeed = slowSpeed;
        this.fastSpeed = fastSpeed;
        this.fleeingEntityNavigation = mob.m_21573_();
        this.pathNav = mob.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        this.targetBlock = this.getClosestBlockEntity(this.mob);
        if (this.targetBlock == null) {
            return false;
        }
        Vec3 vec3d = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.targetBlock.m_58899_().m_252807_());
        if (vec3d == null) {
            return false;
        }
        if (vec3d.m_82531_((double)this.targetBlock.m_58899_().m_123341_(), (double)this.targetBlock.m_58899_().m_123342_(), (double)this.targetBlock.m_58899_().m_123343_()) < this.mob.m_20238_(this.targetBlock.m_58899_().m_252807_())) {
            return false;
        }
        this.fleePath = this.pathNav.m_26524_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 0);
        return this.fleePath != null;
    }

    private BlockEntity getClosestBlockEntity(PathfinderMob fleeingEntity) {
        BlockEntity closestBlockEntity = null;
        double closestDistanceSq = Double.MAX_VALUE;
        List<BlockEntity> blockEntities = this.getBlockEntitiesInRange(fleeingEntity);
        for (BlockEntity blockEntity : blockEntities) {
            double distanceSq = blockEntity.m_58899_().m_203193_((Position)fleeingEntity.m_20182_());
            if (!(distanceSq < closestDistanceSq)) continue;
            closestBlockEntity = blockEntity;
            closestDistanceSq = distanceSq;
        }
        return closestBlockEntity;
    }

    private List<BlockEntity> getBlockEntitiesInRange(PathfinderMob fleeingEntity) {
        ArrayList<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        int chunkX = (int)Math.floor(fleeingEntity.m_20182_().m_7096_()) >> 4;
        int chunkZ = (int)Math.floor(fleeingEntity.m_20182_().m_7094_()) >> 4;
        LevelChunk chunk = fleeingEntity.m_9236_().m_6325_(chunkX, chunkZ);
        Set blockEntityPos = chunk.m_5928_();
        for (BlockPos blockPos : blockEntityPos) {
            BlockEntity blockEntity = fleeingEntity.m_9236_().m_7702_(blockPos);
            if (blockEntity == null || blockEntity.getClass() != this.classToFleeFrom || !this.isWithinDistance(blockEntity.m_58899_(), fleeingEntity.m_20182_())) continue;
            blockEntities.add(blockEntity);
        }
        return blockEntities;
    }

    private boolean isWithinDistance(BlockPos blockposition, Vec3 position) {
        return blockposition.m_203193_((Position)position) - (double)BetterArcheologyConfig.fossilFleeRange.get().intValue() <= 0.0;
    }

    public boolean m_8045_() {
        return !this.pathNav.m_26571_();
    }

    public void m_8056_() {
        this.pathNav.m_26536_(this.fleePath, this.slowSpeed);
    }

    public void m_8041_() {
        this.targetBlock = null;
    }

    public void m_8037_() {
        if (this.targetBlock != null && this.mob.m_20238_(this.targetBlock.m_58899_().m_252807_()) < 49.0) {
            this.mob.m_21573_().m_26517_(this.fastSpeed);
        } else {
            this.mob.m_21573_().m_26517_(this.slowSpeed);
        }
    }
}

