/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Optional;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTRecipeComponents;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.handler.MekanismRecipeHandler;
import mekanism.common.integration.crafttweaker.recipe.manager.ChemicalDissolutionRecipeManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

@IRecipeHandler.For(value=ChemicalDissolutionRecipe.class)
public class ChemicalDissolutionRecipeHandler
extends MekanismRecipeHandler<ChemicalDissolutionRecipe> {
    public String dumpToCommandString(IRecipeManager<? super ChemicalDissolutionRecipe> manager, ChemicalDissolutionRecipe recipe) {
        return this.buildCommandString(manager, recipe, recipe.getItemInput(), recipe.getGasInput(), recipe.getOutputDefinition());
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super ChemicalDissolutionRecipe> manager, ChemicalDissolutionRecipe recipe, U o) {
        if (o instanceof ChemicalDissolutionRecipe) {
            ChemicalDissolutionRecipe other = (ChemicalDissolutionRecipe)o;
            return this.ingredientConflicts(recipe.getItemInput(), other.getItemInput()) && this.ingredientConflicts(recipe.getGasInput(), other.getGasInput());
        }
        return false;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super ChemicalDissolutionRecipe> manager, ChemicalDissolutionRecipe recipe) {
        return this.decompose(recipe.getItemInput(), recipe.getGasInput(), recipe.getOutputDefinition());
    }

    public Optional<ChemicalDissolutionRecipe> recompose(IRecipeManager<? super ChemicalDissolutionRecipe> m, ResourceLocation name, IDecomposedRecipe recipe) {
        if (m instanceof ChemicalDissolutionRecipeManager) {
            ChemicalDissolutionRecipeManager manager = (ChemicalDissolutionRecipeManager)m;
            Optional output = CrTRecipeComponents.CHEMICAL_COMPONENTS.stream().map(chemicalComponent -> CrTUtils.getSingleIfPresent(recipe, chemicalComponent.output())).filter(Optional::isPresent).findFirst().flatMap(singleIfPresent -> singleIfPresent);
            return Optional.of(manager.makeRecipe(name, (ItemStackIngredient)recipe.getOrThrowSingle(CrTRecipeComponents.ITEM.input()), (ChemicalStackIngredient.GasStackIngredient)recipe.getOrThrowSingle(CrTRecipeComponents.GAS.input()), (ICrTChemicalStack)output.orElseThrow(() -> new IllegalArgumentException("No specified output chemical."))));
        }
        return Optional.empty();
    }
}

