/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.processor;

import com.crypticmushroom.minecraft.midnight.common.registry.MnStructureProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseDisintegrationProcessor
extends StructureProcessor {
    public static final Codec<NoiseDisintegrationProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)-1.0, (double)1.0).fieldOf("threshold").forGetter(processor -> processor.threshold), (App)NormalNoise.NoiseParameters.f_192851_.fieldOf("noise_parameters").forGetter(processor -> processor.parameters)).apply((Applicative)instance, NoiseDisintegrationProcessor::new));
    private final double threshold;
    private final NormalNoise.NoiseParameters parameters;

    public NoiseDisintegrationProcessor(double threshold, NormalNoise.NoiseParameters noiseParameters) {
        this.threshold = threshold;
        this.parameters = noiseParameters;
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos posA, BlockPos posB, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoWorld, StructurePlaceSettings settings, StructureTemplate template) {
        double addition;
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(Mth.m_14057_((Vec3i)blockInfoWorld.f_74675_())));
        NormalNoise noise = NormalNoise.m_230511_((RandomSource)rand, (NormalNoise.NoiseParameters)this.parameters);
        int height = blockInfoLocal.f_74675_().m_123342_();
        double val = noise.m_75380_((double)blockInfoWorld.f_74675_().m_123341_(), (double)height, (double)blockInfoWorld.f_74675_().m_123343_());
        if (val + (addition = Math.min(8.0 * (1.0 / (double)Mth.m_144944_((int)height)), 2.0)) > this.threshold || blockInfoWorld.f_74676_().m_60795_() || !blockInfoWorld.f_74676_().m_60819_().m_76178_()) {
            return blockInfoWorld;
        }
        return new StructureTemplate.StructureBlockInfo(blockInfoWorld.f_74675_(), Blocks.f_50016_.m_49966_(), blockInfoWorld.f_74677_());
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)MnStructureProcessorTypes.NOISE_DISINTEGRATE_PROCESSOR.get();
    }
}

