/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.processor;

import com.crypticmushroom.minecraft.midnight.common.registry.MnStructureProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class HangingLeavesProcessor
extends StructureProcessor {
    public static final Codec<HangingLeavesProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("chance").forGetter(processor -> processor.attachChance), (App)BlockStateProvider.f_68747_.fieldOf("base_provider").forGetter(processor -> processor.baseStateProvider), (App)BlockStateProvider.f_68747_.fieldOf("end_provider").forGetter(processor -> processor.endStateProvider)).apply((Applicative)instance, HangingLeavesProcessor::new));
    private final int attachChance;
    private final BlockStateProvider baseStateProvider;
    private final BlockStateProvider endStateProvider;

    public HangingLeavesProcessor(int attachChance, BlockStateProvider baseStateProvider, BlockStateProvider endStateProvider) {
        this.attachChance = attachChance;
        this.baseStateProvider = baseStateProvider;
        this.endStateProvider = endStateProvider;
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos pos, BlockPos blockpos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoWorld, StructurePlaceSettings settings, StructureTemplate template) {
        RandomSource rand = settings.m_230326_(blockInfoWorld.f_74675_());
        ChunkAccess chunk = world.m_46865_(blockInfoWorld.f_74675_());
        if (blockInfoWorld.f_74676_().m_60838_((BlockGetter)world, blockInfoWorld.f_74675_()) && blockInfoWorld.f_74676_().m_204336_(BlockTags.f_13035_) && rand.m_188503_(this.attachChance) == 0) {
            if (rand.m_188503_(2) == 0) {
                chunk.m_6978_(blockInfoWorld.f_74675_().m_7495_(), this.endStateProvider.m_213972_(rand, blockInfoWorld.f_74675_().m_7495_()), false);
            } else {
                chunk.m_6978_(blockInfoWorld.f_74675_().m_7495_(), this.baseStateProvider.m_213972_(rand, blockInfoWorld.f_74675_().m_7495_()), false);
                chunk.m_6978_(blockInfoWorld.f_74675_().m_6625_(2), this.endStateProvider.m_213972_(rand, blockInfoWorld.f_74675_().m_6625_(2)), false);
            }
        }
        return blockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)MnStructureProcessorTypes.HANGING_LEAVES_PROCESSOR.get();
    }
}

