/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature.tree.trunkplacer;

import com.crypticmushroom.minecraft.midnight.common.registry.MnTrunkPlacerTypes;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class WillowTrunkPlacer
extends TrunkPlacer {
    public static final Codec<WillowTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> WillowTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.f_146533_.fieldOf("base_radius").forGetter(trunkPlacer -> trunkPlacer.baseRadius), (App)FloatProvider.f_146502_.fieldOf("base_noise_scale_xz").forGetter(trunkPlacer -> trunkPlacer.baseNoiseScaleXZ), (App)FloatProvider.f_146502_.fieldOf("base_noise_scale_y").forGetter(trunkPlacer -> trunkPlacer.baseNoiseScaleY), (App)IntProvider.f_146533_.fieldOf("limb_distance_xz").forGetter(trunkPlacer -> trunkPlacer.limbDistXZ), (App)IntProvider.f_146533_.fieldOf("limb_distance_y").forGetter(trunkPlacer -> trunkPlacer.limbDistY))).apply((Applicative)instance, WillowTrunkPlacer::new));
    private final IntProvider baseRadius;
    private final FloatProvider baseNoiseScaleXZ;
    private final FloatProvider baseNoiseScaleY;
    private final IntProvider limbDistXZ;
    private final IntProvider limbDistY;

    public WillowTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, IntProvider baseRadius, FloatProvider baseNoiseScaleXZ, FloatProvider baseNoiseScaleY, IntProvider limbDistXZ, IntProvider limbDistY) {
        super(baseHeight, heightRandA, heightRandB);
        this.baseRadius = baseRadius;
        this.baseNoiseScaleXZ = baseNoiseScaleXZ;
        this.baseNoiseScaleY = baseNoiseScaleY;
        this.limbDistXZ = limbDistXZ;
        this.limbDistY = limbDistY;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)MnTrunkPlacerTypes.WILLOW_TRUNK.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource rand, int height, BlockPos basePos, TreeConfiguration config) {
        ArrayList foliageAttachments = Lists.newArrayList();
        BlockPos basePosDirt = basePos.m_7495_();
        WillowTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)rand, (BlockPos)basePosDirt, (TreeConfiguration)config);
        WillowTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)rand, (BlockPos)basePosDirt.m_122029_(), (TreeConfiguration)config);
        WillowTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)rand, (BlockPos)basePosDirt.m_122019_(), (TreeConfiguration)config);
        WillowTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)rand, (BlockPos)basePosDirt.m_122019_().m_122029_(), (TreeConfiguration)config);
        int x = basePos.m_123341_();
        int y = basePos.m_123342_();
        int z = basePos.m_123343_();
        BlockPos currentPos = basePos;
        for (int currentHeight = 0; currentHeight < height; ++currentHeight) {
            currentPos = new BlockPos(x, y + currentHeight, z);
            if (!TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)currentPos)) continue;
            this.m_226187_(level, blockSetter, rand, currentPos, config);
            this.m_226187_(level, blockSetter, rand, currentPos.m_122029_(), config);
            this.m_226187_(level, blockSetter, rand, currentPos.m_122019_(), config);
            this.m_226187_(level, blockSetter, rand, currentPos.m_122029_().m_122019_(), config);
        }
        BlockPos topPos = currentPos.m_7918_(rand.m_188503_(1), 1, rand.m_188503_(1));
        this.m_226187_(level, blockSetter, rand, topPos, config);
        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(topPos.m_7494_(), 0, true));
        int limbDistX1 = this.limbDistXZ.m_214085_(rand);
        this.makeLimb(level, blockSetter, rand, currentPos, currentPos.m_7918_(this.limbDistXZ.m_214085_(rand), this.limbDistY.m_214085_(rand), this.limbDistXZ.m_214085_(rand)), true, config, foliageAttachments);
        this.makeLimb(level, blockSetter, rand, currentPos, currentPos.m_7918_(-this.limbDistXZ.m_214085_(rand), this.limbDistY.m_214085_(rand), this.limbDistXZ.m_214085_(rand)), true, config, foliageAttachments);
        this.makeLimb(level, blockSetter, rand, currentPos, currentPos.m_7918_(this.limbDistXZ.m_214085_(rand), this.limbDistY.m_214085_(rand), -this.limbDistXZ.m_214085_(rand)), true, config, foliageAttachments);
        this.makeLimb(level, blockSetter, rand, currentPos, currentPos.m_7918_(-this.limbDistXZ.m_214085_(rand), this.limbDistY.m_214085_(rand), -this.limbDistXZ.m_214085_(rand)), true, config, foliageAttachments);
        this.generateBase(level, blockSetter, rand, basePosDirt.m_7918_(rand.m_188503_(2), 0, rand.m_188503_(2)), config);
        return foliageAttachments;
    }

    private void generateBase(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource rand, BlockPos origin, TreeConfiguration config) {
        NormalNoise noise = NormalNoise.m_230504_((RandomSource)rand, (int)-3, (double[])new double[]{1.0, 0.5});
        float radius = this.baseRadius.m_214085_(rand);
        float radiusSquare = radius * radius;
        int radiusCeil = Mth.m_14167_((float)radius);
        BlockPos minPos = origin.m_7918_(-radiusCeil, 0, -radiusCeil);
        BlockPos maxPos = origin.m_7918_(radiusCeil, radiusCeil, radiusCeil);
        BlockPos.m_121990_((BlockPos)minPos, (BlockPos)maxPos).forEach(pos -> {
            double noiseVal = noise.m_75380_((double)((float)pos.m_123341_() * this.baseNoiseScaleXZ.m_214084_(rand)), (double)((float)pos.m_123342_() * this.baseNoiseScaleY.m_214084_(rand)), (double)((float)pos.m_123343_() * this.baseNoiseScaleXZ.m_214084_(rand)));
            double distSqr = pos.m_123331_((Vec3i)origin);
            double density = (double)radiusSquare - distSqr + noiseVal * 4.0;
            if (density > 0.0) {
                this.m_226187_(level, blockSetter, rand, (BlockPos)pos, config);
                if (pos.m_123342_() == origin.m_123342_()) {
                    WillowTrunkPlacer.m_226169_((LevelSimulatedReader)level, (BiConsumer)blockSetter, (RandomSource)rand, (BlockPos)pos, (TreeConfiguration)config);
                }
            }
        });
    }

    private boolean makeLimb(LevelSimulatedReader levelReader, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource rand, BlockPos startPos, BlockPos endPos, boolean p_226113_, TreeConfiguration cfg, List<FoliagePlacer.FoliageAttachment> foliageAttachments) {
        if (!p_226113_ && Objects.equals(startPos, endPos)) {
            return true;
        }
        BlockPos blockpos = endPos.m_7918_(-startPos.m_123341_(), -startPos.m_123342_(), -startPos.m_123343_());
        int i = this.getSteps(blockpos);
        float f = (float)blockpos.m_123341_() / (float)i;
        float f1 = (float)blockpos.m_123342_() / (float)i;
        float f2 = (float)blockpos.m_123343_() / (float)i;
        BlockPos foliagePos = startPos;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = startPos.m_7918_(Mth.m_14143_((float)(0.5f + (float)j * f)), Mth.m_14143_((float)(0.5f + (float)j * f1)), Mth.m_14143_((float)(0.5f + (float)j * f2)));
            if (p_226113_) {
                foliagePos = blockpos1;
                this.m_226187_(levelReader, blockSetter, rand, blockpos1, cfg);
                this.m_226187_(levelReader, blockSetter, rand, blockpos1.m_7495_(), cfg);
                continue;
            }
            if (this.m_226184_(levelReader, blockpos1)) continue;
            return false;
        }
        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(foliagePos, 0, false));
        return true;
    }

    private int getSteps(BlockPos pos) {
        int i = Mth.m_14040_((int)pos.m_123341_());
        int j = Mth.m_14040_((int)pos.m_123342_());
        int k = Mth.m_14040_((int)pos.m_123343_());
        return Math.max(i, Math.max(j, k));
    }

    public List<FoliagePlacer.FoliageAttachment> test(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> consumer, RandomSource rand, int height, BlockPos basePos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos blockpos = basePos.m_7495_();
        WillowTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)rand, (BlockPos)blockpos, (TreeConfiguration)config);
        WillowTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)rand, (BlockPos)blockpos.m_122029_(), (TreeConfiguration)config);
        WillowTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)rand, (BlockPos)blockpos.m_122019_(), (TreeConfiguration)config);
        WillowTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)rand, (BlockPos)blockpos.m_122019_().m_122029_(), (TreeConfiguration)config);
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(rand);
        int splittingHeight = height - rand.m_188503_(4);
        int j = 2 - rand.m_188503_(3);
        int baseX = basePos.m_123341_();
        int baseY = basePos.m_123342_();
        int baseZ = basePos.m_123343_();
        int x = baseX;
        int z = baseZ;
        int maxY = baseY + height - 1;
        for (int currentHeight = 0; currentHeight < height; ++currentHeight) {
            int currentY;
            BlockPos currentPos;
            if (currentHeight >= splittingHeight && j > 0) {
                x += direction.m_122429_();
                z += direction.m_122431_();
                --j;
            }
            if (!TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)(currentPos = new BlockPos(x, currentY = baseY + currentHeight, z)))) continue;
            this.m_226187_(level, consumer, rand, currentPos, config);
            this.m_226187_(level, consumer, rand, currentPos.m_122029_(), config);
            this.m_226187_(level, consumer, rand, currentPos.m_122019_(), config);
            this.m_226187_(level, consumer, rand, currentPos.m_122029_().m_122019_(), config);
        }
        list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(x, maxY, z), 0, true));
        for (int l2 = -1; l2 <= 2; ++l2) {
            for (int i3 = -1; i3 <= 2; ++i3) {
                if (l2 >= 0 && l2 <= 1 && i3 >= 0 && i3 <= 1 || rand.m_188503_(3) > 0) continue;
                int j3 = rand.m_188503_(3) + 2;
                for (int k2 = 0; k2 < j3; ++k2) {
                    this.m_226187_(level, consumer, rand, new BlockPos(baseX + l2, maxY - k2 - 1, baseZ + i3), config);
                }
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(x + l2, maxY, z + i3), 0, false));
            }
        }
        return list;
    }
}

