/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature.tree;

import com.crypticmushroom.minecraft.midnight.common.block.MidnightDirtBlock;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.MidnightTreeConfig;
import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.tree.AbstractMnTreeFeature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class ShadowrootTreeFeature
extends AbstractMnTreeFeature<MidnightTreeConfig> {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final int BRANCH_SPACING = 3;

    public ShadowrootTreeFeature() {
        super(MidnightTreeConfig.CODEC, () -> MnBlocks.SHADOWROOT_SAPLING.get());
    }

    @Override
    protected boolean place(WorldGenLevel level, ChunkGenerator chunkGen, RandomSource rand, BlockPos origin, MidnightTreeConfig config) {
        int height = config.height.m_214085_(rand);
        if (!this.canFit(level, origin, 1, height)) {
            return false;
        }
        if (this.isSoil(level, origin.m_7495_())) {
            this.m_5974_((LevelWriter)level, origin.m_7495_(), ((MidnightDirtBlock)((Object)MnBlocks.NIGHT_DIRT.get())).m_49966_());
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        for (int localY = 0; localY < height; ++localY) {
            mutablePos.m_142448_(origin.m_123342_() + localY);
            this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, config.logProvider.m_213972_(rand, (BlockPos)mutablePos));
        }
        this.generateRoots((LevelSimulatedRW)level, rand, origin, config);
        Set<Branch> branches = this.collectBranches(level, rand, origin, height);
        for (Branch branch : branches) {
            this.m_5974_((LevelWriter)level, branch.pos, (BlockState)config.logProvider.m_213972_(rand, (BlockPos)mutablePos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)branch.getAxis()));
        }
        Set<BlockPos> leafPositions = this.produceBlob(origin.m_6630_(height - 2), 1.5, 2.5);
        leafPositions = this.droopLeaves(leafPositions, rand, 4);
        for (Branch branch : branches) {
            leafPositions.addAll(this.collectBranchLeaves(branch, rand));
        }
        for (BlockPos leafPos : leafPositions) {
            if (!this.canGrowInto(level, leafPos)) continue;
            this.m_5974_((LevelWriter)level, leafPos, (BlockState)config.leavesProvider.m_213972_(rand, (BlockPos)mutablePos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(6)));
        }
        return true;
    }

    private boolean canFit(WorldGenLevel level, BlockPos origin, int width, int height) {
        BlockPos min = origin.m_7918_(-width, 0, -width);
        BlockPos max = origin.m_7918_(width, height, width);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            if (this.canGrowInto(level, pos)) continue;
            return false;
        }
        return true;
    }

    private void generateRoots(LevelSimulatedRW level, RandomSource rand, BlockPos origin, MidnightTreeConfig config) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ArrayList availableSides = Lists.newArrayList((Object[])HORIZONTALS);
        int count = rand.m_188503_(3) + 1;
        for (int i = 0; i < count; ++i) {
            Direction side = (Direction)availableSides.remove(rand.m_188503_(availableSides.size()));
            BlockPos rootOrigin = origin.m_121945_(side);
            int height = rand.m_188503_(3) + 1;
            for (int localY = 0; localY < height; ++localY) {
                mutablePos.m_122178_(rootOrigin.m_123341_(), rootOrigin.m_123342_() + localY, rootOrigin.m_123343_());
                this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, config.logProvider.m_213972_(rand, (BlockPos)mutablePos));
            }
        }
    }

    private Set<BlockPos> droopLeaves(Set<BlockPos> leafPositions, RandomSource random, int amount) {
        HashSet<BlockPos> droopedLeaves = new HashSet<BlockPos>(leafPositions);
        for (BlockPos pos : leafPositions) {
            int droopAmount = random.m_188503_(amount);
            for (int i = 0; i < droopAmount; ++i) {
                droopedLeaves.add(pos.m_6625_(i));
            }
        }
        return droopedLeaves;
    }

    private Set<Branch> collectBranches(WorldGenLevel world, RandomSource random, BlockPos origin, int height) {
        int minBranchHeight = 3;
        int maxBranchHeight = height - 4;
        int heightRange = maxBranchHeight - minBranchHeight;
        HashSet<Branch> branches = new HashSet<Branch>();
        int branchCount = heightRange / 3;
        double normalizedSpacing = (double)heightRange / (double)branchCount;
        Direction lastDirection = null;
        for (int branch = 0; branch < branchCount; ++branch) {
            int y = Mth.m_14165_((double)((double)(minBranchHeight + 1) + (double)branch * normalizedSpacing));
            Direction direction = null;
            while (direction == null || direction == lastDirection) {
                direction = HORIZONTALS[random.m_188503_(HORIZONTALS.length)];
            }
            lastDirection = direction;
            BlockPos branchPos = origin.m_6630_(y).m_121945_(direction);
            if (!this.isAirOrLeaves(world, branchPos)) continue;
            float outerAngle = direction.m_122435_();
            float angle = random.m_188501_() * 90.0f + outerAngle - 45.0f;
            branches.add(new Branch(branchPos, direction, angle));
        }
        return branches;
    }

    private Set<BlockPos> collectBranchLeaves(Branch branch, RandomSource random) {
        HashSet<BlockPos> branchLeaves = new HashSet<BlockPos>();
        float theta = (float)Math.toRadians(branch.angle);
        float deltaX = -Mth.m_14031_((float)theta);
        float deltaZ = Mth.m_14089_((float)theta);
        for (int step = 0; step < 3; ++step) {
            int droop = -step / 2 + 1;
            BlockPos origin = ShadowrootTreeFeature.blockPosOffset(branch.pos, deltaX * (float)step, droop, deltaZ * (float)step);
            Set<BlockPos> stepLeaves = this.produceBlob(origin, 1.0);
            branchLeaves.addAll(this.droopLeaves(stepLeaves, random, step + 1));
        }
        return branchLeaves;
    }

    @Deprecated(forRemoval=true)
    private static BlockPos blockPosOffset(BlockPos pos, double d0, double d1, double d2) {
        return d0 == 0.0 && d1 == 0.0 && d2 == 0.0 ? pos : BlockPos.m_274561_((double)((double)pos.m_123341_() + d0), (double)((double)pos.m_123342_() + d1), (double)((double)pos.m_123343_() + d2));
    }

    private record Branch(BlockPos pos, Direction direction, float angle) {
        public Direction.Axis getAxis() {
            return this.direction.m_122434_();
        }

        @Override
        public int hashCode() {
            return this.pos.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Branch && ((Branch)obj).pos.equals((Object)this.pos);
        }
    }
}

