/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature.template;

import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.TemplateTreeConfig;
import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.template.BasicTemplateFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TreeTemplateFeature
extends BasicTemplateFeature<TemplateTreeConfig> {
    public TreeTemplateFeature() {
        super(TemplateTreeConfig.CODEC);
    }

    @Override
    protected BlockPos adjustPosition(WorldGenLevel level, StructureTemplate template, BlockPos templateZero, BlockPos offset, BlockPos origin, Vec3i size, Rotation rot, TemplateTreeConfig config) {
        int trunkRadius = config.trunkRadius;
        BlockPos pos1 = origin.m_7918_(-trunkRadius, 0, -trunkRadius);
        BlockPos pos2 = origin.m_7918_(-trunkRadius, 0, trunkRadius);
        BlockPos pos3 = origin.m_7918_(trunkRadius, 0, -trunkRadius);
        BlockPos pos4 = origin.m_7918_(trunkRadius, 0, trunkRadius);
        for (int i = 0; i < config.maxDownwardOffset; ++i) {
            pos1 = pos1.m_7495_();
            pos2 = pos2.m_7495_();
            pos3 = pos3.m_7495_();
            pos4 = pos4.m_7495_();
            BlockState state1 = level.m_8055_(pos1);
            BlockState state2 = level.m_8055_(pos2);
            BlockState state3 = level.m_8055_(pos3);
            BlockState state4 = level.m_8055_(pos4);
            if (state1.m_60838_((BlockGetter)level, pos1) && state2.m_60838_((BlockGetter)level, pos2) && state3.m_60838_((BlockGetter)level, pos3) && state4.m_60838_((BlockGetter)level, pos4)) {
                if (BlockPos.m_121990_((BlockPos)pos1.m_7494_(), (BlockPos)templateZero.m_121955_(template.m_163808_(rot))).allMatch(blockPos -> TreeTemplateFeature.isBlockValid(blockPos, level))) {
                    return templateZero;
                }
                return null;
            }
            templateZero = templateZero.m_7495_();
        }
        return null;
    }

    private static boolean isBlockValid(BlockPos pos, WorldGenLevel level) {
        BlockState state = level.m_8055_(pos);
        return state.m_247087_() || state.m_204336_(BlockTags.f_278411_) || state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_13063_);
    }
}

