/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config;

import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.TemplateConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class TemplateTreeConfig
extends TemplateConfig {
    public final int maxDownwardOffset;
    public final int trunkRadius;
    public static final Codec<TemplateTreeConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("processor_list").forGetter(config -> config.processorList), (App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("templates").forGetter(config -> config.templates), (App)Codec.INT.fieldOf("max_downward_offset").forGetter(config -> config.maxDownwardOffset), (App)Codec.INT.fieldOf("trunk_radius").forGetter(config -> config.trunkRadius)).apply((Applicative)instance, TemplateTreeConfig::new));

    public TemplateTreeConfig(String templatePrefix, int templateCount, ResourceLocation processorList, int trunkRadius, int maxDownwardOffset) {
        super(templatePrefix, templateCount, true, processorList);
        this.maxDownwardOffset = maxDownwardOffset;
        this.trunkRadius = trunkRadius;
    }

    public TemplateTreeConfig(ResourceLocation template, ResourceLocation processorList, int trunkRadius, int maxDownwardOffset) {
        super(List.of(template), true, processorList);
        this.maxDownwardOffset = maxDownwardOffset;
        this.trunkRadius = trunkRadius;
    }

    public TemplateTreeConfig(ResourceLocation template, int trunkRadius, int maxDownwardOffset) {
        super(List.of(template), true, new ResourceLocation("empty"));
        this.maxDownwardOffset = maxDownwardOffset;
        this.trunkRadius = trunkRadius;
    }

    public TemplateTreeConfig(ResourceLocation processorList, List<ResourceLocation> templates, int trunkRadius, int maxDownwardOffset) {
        super(templates, true, processorList);
        this.maxDownwardOffset = maxDownwardOffset;
        this.trunkRadius = trunkRadius;
    }
}

