/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature;

import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.FairyRingConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class FairyRingFeature
extends Feature<FairyRingConfig> {
    public FairyRingFeature() {
        super(FairyRingConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<FairyRingConfig> ctx) {
        WorldGenLevel level = ctx.m_159774_();
        RandomSource rand = ctx.m_225041_();
        BlockPos origin = ctx.m_159777_();
        FairyRingConfig cfg = (FairyRingConfig)ctx.m_159778_();
        int radius = ((FairyRingConfig)ctx.m_159778_()).radius().m_214085_(rand);
        List<BlockPos> positions = this.calculateSpace(origin, radius, level, rand, cfg);
        if (positions == null) {
            return false;
        }
        positions.forEach(pos -> {
            if (rand.m_188501_() < cfg.chance()) {
                BlockState state = cfg.toPlace().m_213972_(rand, pos);
                if (state.m_60734_() instanceof DoublePlantBlock) {
                    if (level.m_46859_(pos.m_7494_())) {
                        DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)state, (BlockPos)pos, (int)2);
                    }
                } else {
                    level.m_7731_(pos, state, 2);
                }
            }
        });
        return true;
    }

    private BlockPos canPlace(BlockPos origin, WorldGenLevel level) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        for (int y = origin.m_123342_() + 1; y > origin.m_123342_() - 1; --y) {
            mPos.m_142448_(y);
            if (!level.m_46859_((BlockPos)mPos) || !level.m_8055_(mPos.m_7495_()).m_60838_((BlockGetter)level, (BlockPos)mPos)) continue;
            return mPos;
        }
        return null;
    }

    private List<BlockPos> calculateSpace(BlockPos origin, int radius, WorldGenLevel level, RandomSource rand, FairyRingConfig cfg) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        float radiusSquare = radius * radius;
        BlockPos.MutableBlockPos basePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        for (int localX = -radius; localX <= radius; ++localX) {
            for (int localZ = -radius; localZ <= radius; ++localZ) {
                basePos.m_122178_(origin.m_123341_() + localX, origin.m_123342_(), origin.m_123343_() + localZ);
                double distSquare = basePos.m_123331_((Vec3i)origin);
                if (!(distSquare <= (double)radiusSquare) || !(distSquare > (double)(0.75f * radiusSquare - 2.5f))) continue;
                BlockPos toPlacePos = this.canPlace((BlockPos)basePos, level);
                if (toPlacePos == null) {
                    return null;
                }
                validPositions.add(toPlacePos);
            }
        }
        return validPositions;
    }
}

