/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.CrystalClusterConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class CrystalClusterFeature
extends Feature<CrystalClusterConfig> {
    public CrystalClusterFeature() {
        super(CrystalClusterConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<CrystalClusterConfig> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (CrystalClusterConfig)context.m_159778_());
    }

    private boolean place(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, CrystalClusterConfig config) {
        if (!world.m_8055_(pos).m_60795_()) {
            return false;
        }
        int maxHeight = config.height().m_214085_(rand);
        int radius = (int)(Math.sqrt(maxHeight) * (double)0.6f + 2.0);
        float radiusVariation = rand.m_188501_() * (float)radius * config.relativeRadiusVariation();
        int size = (radius = (int)((float)radius + (radiusVariation = radiusVariation * 2.0f - radiusVariation))) * 2 + 1;
        int[] heights = new int[size * size];
        BlockPos basePos = this.populateHeights(world, rand, pos, heights, radius, maxHeight, size, config);
        if (basePos == null || !this.canGenerate(world, pos, heights, radius, size, config)) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int localZ = -radius; localZ <= radius; ++localZ) {
            for (int localX = -radius; localX <= radius; ++localX) {
                int height = heights[localX + radius + (localZ + radius) * size];
                if (height <= 0) continue;
                mutablePos.m_122178_(basePos.m_123341_() + localX, basePos.m_123342_(), basePos.m_123343_() + localZ);
                this.generatePillar(world, rand, mutablePos, height, config);
            }
        }
        return true;
    }

    private boolean canGenerate(WorldGenLevel world, BlockPos origin, int[] heights, int radius, int size, CrystalClusterConfig config) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        int centerHeight = heights[radius + radius * size] + 1;
        for (int localY = 0; localY < centerHeight; ++localY) {
            mutablePos.m_142448_(origin.m_123342_() + localY);
            if (world.m_8055_((BlockPos)mutablePos).m_60795_()) continue;
            return false;
        }
        return true;
    }

    private void generatePillar(WorldGenLevel world, RandomSource rand, BlockPos.MutableBlockPos mutablePos, int height, CrystalClusterConfig config) {
        int originY = mutablePos.m_123342_();
        boolean canGenCrystal = false;
        for (int offsetY = 0; offsetY < height; ++offsetY) {
            mutablePos.m_142448_(originY + offsetY);
            canGenCrystal = this.placeBlock(world, mutablePos, config.mainStateProvider().m_213972_(rand, (BlockPos)mutablePos), config);
        }
        if (canGenCrystal && rand.m_188503_(2) == 0) {
            mutablePos.m_142448_(originY + height);
            this.placeBlock(world, mutablePos, config.topStateProvider().m_213972_(rand, (BlockPos)mutablePos), config);
        }
    }

    private boolean placeBlock(WorldGenLevel world, BlockPos.MutableBlockPos mutablePos, BlockState state, CrystalClusterConfig config) {
        if (!world.m_8055_((BlockPos)mutablePos).m_60795_()) {
            return false;
        }
        this.m_5974_((LevelWriter)world, (BlockPos)mutablePos, state);
        return true;
    }

    private BlockPos populateHeights(WorldGenLevel world, RandomSource rand, BlockPos origin, int[] heights, int radius, int maxHeight, int size, CrystalClusterConfig config) {
        BlockPos.MutableBlockPos basePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        for (int localZ = -radius; localZ <= radius; ++localZ) {
            for (int localX = -radius; localX <= radius; ++localX) {
                double deltaZ;
                int index = localX + radius + (localZ + radius) * size;
                double deltaX = (double)localX + rand.m_188500_() * 2.0 - 1.0;
                double distance = Math.sqrt(deltaX * deltaX + (deltaZ = (double)localZ + rand.m_188500_() * 2.0 - 1.0) * deltaZ);
                double alpha = ((double)radius - distance) / (double)radius;
                int height = Mth.m_14107_((double)(alpha * (double)maxHeight));
                if (height <= 0) continue;
                BlockPos surfacePos = this.findSurfaceBelow(world, origin.m_7918_(localX, 0, localZ), config);
                if (surfacePos == null) {
                    return null;
                }
                if (surfacePos.m_123342_() < basePos.m_123342_()) {
                    basePos.m_142448_(surfacePos.m_123342_());
                }
                heights[index] = height;
            }
        }
        return basePos.m_7949_();
    }

    private BlockPos findSurfaceBelow(WorldGenLevel world, BlockPos origin, CrystalClusterConfig config) {
        BlockState currentState = world.m_8055_(origin);
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        for (int i = 0; i <= 6; ++i) {
            currentPos.m_122173_(Direction.DOWN);
            BlockState nextState = world.m_8055_((BlockPos)currentPos);
            if (nextState == ((Block)MnBlocks.NIGHT_BEDROCK.get()).m_49966_()) {
                return null;
            }
            if (currentState.m_60795_() && nextState.m_60838_((BlockGetter)world, origin)) {
                currentPos.m_122173_(Direction.UP);
                return currentPos.m_7949_();
            }
            currentState = nextState;
        }
        return null;
    }
}

