/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature;

import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.TwoBlockStateProvidingConfig;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class BoulderFeature
extends Feature<TwoBlockStateProvidingConfig> {
    public BoulderFeature(Codec<TwoBlockStateProvidingConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<TwoBlockStateProvidingConfig> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (TwoBlockStateProvidingConfig)context.m_159778_());
    }

    private boolean place(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos origin, TwoBlockStateProvidingConfig config) {
        float baseRadius = 2.0f;
        origin = origin.m_6630_(Mth.m_14143_((float)(baseRadius / 2.0f)));
        this.generateBlob(world, rand, origin, baseRadius, config);
        for (int i = 0; i < 2; ++i) {
            int offsetX = rand.m_188503_(5) - 2;
            int offsetY = -rand.m_188503_(2);
            int offsetZ = rand.m_188503_(5) - 2;
            BlockPos center = origin.m_7918_(offsetX, offsetY, offsetZ);
            float radius = baseRadius + rand.m_188501_() * 0.5f;
            this.generateBlob(world, rand, center, radius, config);
        }
        return true;
    }

    private void generateBlob(WorldGenLevel world, RandomSource rand, BlockPos origin, float radius, TwoBlockStateProvidingConfig config) {
        float radiusSquare = radius * radius;
        int radiusCeil = Mth.m_14167_((float)radius);
        BlockPos minPos = origin.m_7918_(-radiusCeil, -radiusCeil, -radiusCeil);
        BlockPos maxPos = origin.m_7918_(radiusCeil, radiusCeil, radiusCeil);
        BlockPos.m_121990_((BlockPos)minPos, (BlockPos)maxPos).forEach(pos -> {
            double distSquare = pos.m_123331_((Vec3i)origin);
            if (distSquare <= (double)radiusSquare) {
                world.m_7731_(pos, this.getStateForPlacement(world, rand, (BlockPos)pos, distSquare, radiusSquare, config), 3);
            }
        });
    }

    private BlockState getStateForPlacement(WorldGenLevel world, RandomSource rand, BlockPos pos, double distSquare, float radiusSquare, TwoBlockStateProvidingConfig config) {
        return distSquare <= 1.0 ? config.stateProvider2.m_213972_(rand, pos) : config.stateProvider1.m_213972_(rand, pos);
    }
}

