/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBiomes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnNoises;
import com.google.common.collect.ImmutableList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public final class MnSurfaceRuleData {
    private static final SurfaceRules.RuleSource AIR = MnSurfaceRuleData.makeStateRule(() -> Blocks.f_50016_);
    private static final SurfaceRules.RuleSource NIGHT_BEDROCK = MnSurfaceRuleData.makeStateRule(MnBlocks.NIGHT_BEDROCK);
    private static final SurfaceRules.RuleSource NIGHT_GRASS = MnSurfaceRuleData.makeStateRule(MnBlocks.NIGHT_GRASS_BLOCK);
    private static final SurfaceRules.RuleSource NIGHTSTONE = MnSurfaceRuleData.makeStateRule(MnBlocks.NIGHTSTONE);
    private static final SurfaceRules.RuleSource TRENCHSTONE = MnSurfaceRuleData.makeStateRule(MnBlocks.TRENCHSTONE);
    private static final SurfaceRules.RuleSource STRANGE_SAND = MnSurfaceRuleData.makeStateRule(MnBlocks.STRANGE_SAND);
    private static final SurfaceRules.RuleSource NIGHT_DIRT = MnSurfaceRuleData.makeStateRule(MnBlocks.NIGHT_DIRT);
    private static final SurfaceRules.RuleSource COARSE_NIGHT_DIRT = MnSurfaceRuleData.makeStateRule(MnBlocks.COARSE_NIGHT_DIRT);
    private static final SurfaceRules.RuleSource NIGHT_MYCELIUM = MnSurfaceRuleData.makeStateRule(MnBlocks.NIGHT_MYCELIUM);
    private static final SurfaceRules.RuleSource DECEITFUL_PEAT = MnSurfaceRuleData.makeStateRule(MnBlocks.DECEITFUL_PEAT);
    private static final SurfaceRules.RuleSource DECEITFUL_MUD = MnSurfaceRuleData.makeStateRule(MnBlocks.DECEITFUL_MUD);
    private static final SurfaceRules.RuleSource MALIGNANT_PLANT = MnSurfaceRuleData.makeStateRule(MnBlocks.MALIGNANT_PLANT_BLOCK);
    private static final SurfaceRules.RuleSource GLOWING_MALIGNANT_PLANT = MnSurfaceRuleData.makeStateRule(MnBlocks.GLOWING_MALIGNANT_PLANT_BLOCK);

    public static SurfaceRules.RuleSource create() {
        SurfaceRules.ConditionSource isAboveWater = SurfaceRules.m_189382_((int)-1, (int)0);
        SurfaceRules.ConditionSource isMalignantPatch = SurfaceRules.m_189412_(MnNoises.MALIGNANT_PATCH, (double)-1.0, (double)-0.4);
        SurfaceRules.ConditionSource isRockyBiome = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MnBiomes.ROCKY_SHORE, MnBiomes.PHANTASMAL_VALLEY, MnBiomes.OBSCURED_PLATEAU, MnBiomes.BLACK_RIDGE});
        SurfaceRules.ConditionSource isCorruptBiome = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MnBiomes.MALIGNANT_GRASSLAND, MnBiomes.MALEVOLENT_FOREST});
        SurfaceRules.ConditionSource isWetland = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MnBiomes.DECEITFUL_SWAMP, MnBiomes.DECEITFUL_MARSH});
        SurfaceRules.RuleSource sandPatch = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(MnNoises.SURFACE, (double)-1.0, (double)-0.4), (SurfaceRules.RuleSource)STRANGE_SAND);
        SurfaceRules.RuleSource defaultSurface = MnSurfaceRuleData.createSurface(NIGHT_GRASS, NIGHT_DIRT, SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{sandPatch, NIGHT_DIRT}));
        SurfaceRules.RuleSource addMalignantPatches = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isMalignantPatch, (SurfaceRules.RuleSource)MALIGNANT_PLANT);
        SurfaceRules.RuleSource addGlowingMalignantPatches = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isMalignantPatch, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(MnNoises.MALIGNANT_PATCH_FINE, (double)0.5, (double)1.0), (SurfaceRules.RuleSource)GLOWING_MALIGNANT_PLANT), MALIGNANT_PLANT}));
        SurfaceRules.RuleSource addCoarseDirtPatches = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(MnNoises.SURFACE, (double)-1.0, (double)-0.5), (SurfaceRules.RuleSource)COARSE_NIGHT_DIRT), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(MnNoises.SURFACE, (double)0.5, (double)1.0), (SurfaceRules.RuleSource)COARSE_NIGHT_DIRT)});
        SurfaceRules.RuleSource trenchstoneBlobsOnNightstone = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(MnNoises.SURFACE, (double)-1.0, (double)-0.5), (SurfaceRules.RuleSource)TRENCHSTONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(MnNoises.SURFACE, (double)0.5, (double)1.0), (SurfaceRules.RuleSource)TRENCHSTONE), NIGHTSTONE});
        SurfaceRules.RuleSource wetlandSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(MnNoises.SURFACE_2, (double)-1.0, (double)-0.1), (SurfaceRules.RuleSource)defaultSurface), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(MnNoises.SURFACE_2, (double)-0.1, (double)0.4), (SurfaceRules.RuleSource)DECEITFUL_MUD), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(MnNoises.SURFACE_2, (double)0.4, (double)1.0), (SurfaceRules.RuleSource)DECEITFUL_PEAT)});
        SurfaceRules.RuleSource biomeSurfaces = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isRockyBiome, (SurfaceRules.RuleSource)MnSurfaceRuleData.createSurface(NIGHTSTONE)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isCorruptBiome, (SurfaceRules.RuleSource)MnSurfaceRuleData.createSurface(addGlowingMalignantPatches, addMalignantPatches)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MnBiomes.OBSCURED_PEAKS}), (SurfaceRules.RuleSource)MnSurfaceRuleData.createSurface(trenchstoneBlobsOnNightstone)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MnBiomes.DEAD_FOREST}), (SurfaceRules.RuleSource)MnSurfaceRuleData.createSurface(addCoarseDirtPatches)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isWetland, (SurfaceRules.RuleSource)MnSurfaceRuleData.createSurface(wetlandSurface)), defaultSurface});
        SurfaceRules.RuleSource caveFloors = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MnBiomes.FUNGAL_CAVERNS}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)NIGHT_MYCELIUM)))});
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)NIGHT_BEDROCK));
        builder.add((Object)caveFloors);
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)biomeSurfaces));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.RuleSource makeStateRule(Supplier<? extends Block> block) {
        return SurfaceRules.m_189390_((BlockState)block.get().m_49966_());
    }

    private static SurfaceRules.RuleSource createSurface(SurfaceRules.RuleSource onFloor, SurfaceRules.RuleSource underFloor, SurfaceRules.RuleSource onFloorUnderwater, SurfaceRules.RuleSource underFloorUnderwater) {
        SurfaceRules.ConditionSource isAboveWater = SurfaceRules.m_189382_((int)-1, (int)0);
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)onFloor), onFloorUnderwater})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isAboveWater, (SurfaceRules.RuleSource)underFloor), underFloorUnderwater}))});
    }

    private static SurfaceRules.RuleSource createSurface(SurfaceRules.RuleSource onFloor, SurfaceRules.RuleSource underFloor, SurfaceRules.RuleSource underwater) {
        return MnSurfaceRuleData.createSurface(onFloor, underFloor, underwater, underwater);
    }

    private static SurfaceRules.RuleSource createSurface(SurfaceRules.RuleSource onFloor, SurfaceRules.RuleSource underFloor) {
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)onFloor), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)underFloor)});
    }

    private static SurfaceRules.RuleSource createSurface(SurfaceRules.RuleSource ruleSource) {
        return MnSurfaceRuleData.createSurface(ruleSource, ruleSource);
    }
}

