/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.dimension;

import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public interface IMnTeleporter
extends ITeleporter {
    @Deprecated
    default public Entity placeEntity(Entity entity, ServerLevel currentLevel, ServerLevel destLevel, float yaw, Function<Boolean, Entity> repositionEntity) {
        Entity entity2;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            entity2 = this.placePlayer(player, currentLevel, destLevel, yaw);
        } else {
            entity2 = this.placeEntity(entity, currentLevel, destLevel, yaw);
        }
        Entity placement = entity2;
        return placement != null ? placement : repositionEntity.apply(false);
    }

    @Nullable
    default public Entity placeEntity(Entity entity, ServerLevel currentLevel, ServerLevel destLevel, float yaw) {
        return null;
    }

    @Nullable
    default public ServerPlayer placePlayer(ServerPlayer player, ServerLevel currentLevel, ServerLevel destLevel, float yaw) {
        return null;
    }

    default public boolean canTeleport(Entity entity, ResourceKey<Level> dimension) {
        return true;
    }

    default public PortalInfo getPortalInfo(Entity entity, ServerLevel destLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        return new PortalInfo(entity.m_20182_(), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    @Deprecated
    default public boolean isVanilla() {
        return false;
    }

    @Deprecated
    default public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceLevel, ServerLevel destLevel) {
        TeleportSoundInfo teleportSoundInfo = this.getTeleportSoundInfo(player, sourceLevel, destLevel);
        return false;
    }

    default public TeleportSoundInfo getTeleportSoundInfo(ServerPlayer player, ServerLevel sourceLevel, ServerLevel destLevel) {
        return new TeleportSoundInfo.Simple(SoundEvents.f_12287_, player.m_9236_().f_46441_.m_188501_() * 0.4f + 0.8f, 0.25f);
    }

    public static interface TeleportSoundInfo {
        public SoundEvent getTeleportSoundEvent();

        public float getTeleportSoundPitch();

        public float getTeleportSoundVolume();

        public record Simple(SoundEvent soundEvent, float pitch, float volume) implements TeleportSoundInfo
        {
            @Override
            public SoundEvent getTeleportSoundEvent() {
                return this.soundEvent;
            }

            @Override
            public float getTeleportSoundPitch() {
                return this.pitch;
            }

            @Override
            public float getTeleportSoundVolume() {
                return this.volume;
            }
        }
    }
}

