/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.biome.util;

import com.crypticmushroom.minecraft.midnight.common.registry.MnConfiguredCarvers;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnPlacedFeatures;
import com.crypticmushroom.minecraft.registry.directory.RegistryDirectory;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class MnBiomeDefaultFeatures {
    public static BiomeGenerationSettings.Builder globalGeneration(BootstapContext<Biome> bootstrap) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(RegistryDirectory.PLACED_FEATURE.getKey()), bootstrap.m_255420_(RegistryDirectory.CONFIGURED_WORLD_CARVER.getKey()));
        MnBiomeDefaultFeatures.addDefaultCarvers(builder);
        MnBiomeDefaultFeatures.addDefaultUndergroundVariety(builder);
        return builder;
    }

    public static void addDefaultUndergroundVariety(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, MnPlacedFeatures.UNDERGROUND_NIGHT_DIRT);
    }

    public static void addDefaultCarvers(BiomeGenerationSettings.Builder builder) {
        builder.m_255308_(GenerationStep.Carving.AIR, MnConfiguredCarvers.MIDNIGHT_CAVE);
    }

    public static void addOres(BiomeGenerationSettings.Builder builder) {
        MnBiomeDefaultFeatures.addOres(builder, false, false);
    }

    public static void addOres(BiomeGenerationSettings.Builder builder, boolean largeDarkPearlOre, boolean extraRendium) {
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, largeDarkPearlOre ? MnPlacedFeatures.DARK_PEARL_ORE_LARGE : MnPlacedFeatures.DARK_PEARL_ORE);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, extraRendium ? MnPlacedFeatures.RENDIUM_ORE_EXTRA : MnPlacedFeatures.RENDIUM_ORE);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, MnPlacedFeatures.EBONITE_ORE);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, MnPlacedFeatures.NAGRILITE_ORE);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, MnPlacedFeatures.NAGRILITE_ORE_WIDE);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, MnPlacedFeatures.VIRILUX_ORE);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, MnPlacedFeatures.TENEBRUM_ORE_UPPER);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, MnPlacedFeatures.TENEBRUM_ORE_LOWER);
    }

    public static void addPits(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, MnPlacedFeatures.PIT);
    }

    public static void addNightstoneBoulders(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MnPlacedFeatures.NIGHTSTONE_BOULDER);
    }

    public static void addTrenchstoneBoulders(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MnPlacedFeatures.TRENCHSTONE_BOULDER);
    }

    public static void addSpikes(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MnPlacedFeatures.NIGHTSTONE_SPIKE);
    }

    public static void addRockshroomHeaps(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MnPlacedFeatures.ROCKSHROOM_HEAP);
    }

    public static void addBloomcrystalClusters(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MnPlacedFeatures.BLOOMCRYSTAL_CLUSTERS);
    }

    public static void addLowCorruptionFeatures(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MnPlacedFeatures.MALIGNANT_PATCH_RARE);
    }

    public static void addMediumCorruptionFeatures(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MnPlacedFeatures.MALIGNANT_PATCH_UNCOMMON);
    }

    public static void addHighCorruptionFeatures(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MnPlacedFeatures.MALIGNANT_PATCH_COMMON);
    }

    public static void addFungiForestVegetation(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.GIANT_NIGHTSHROOMS);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.GIANT_DEWSHROOMS);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.GIANT_VIRIDSHROOMS);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.SHROOM_SHELVES);
        MnBiomeDefaultFeatures.addNightshrooms(builder);
        MnBiomeDefaultFeatures.addDewshrooms(builder);
        MnBiomeDefaultFeatures.addViridshrooms(builder);
    }

    public static void addSmallGiantNightshrooms(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.SPARSE_SMALL_GIANT_NIGHTSHROOMS);
    }

    public static void addSmallAndMediumGiantNightshrooms(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.SPARSE_SMALL_MEDIUM_GIANT_NIGHTSHROOMS);
    }

    public static void addDeadTrees(BiomeGenerationSettings.Builder builder, boolean sparse) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, sparse ? MnPlacedFeatures.DEAD_TREES_SPARSE : MnPlacedFeatures.DEAD_TREES_DENSE);
    }

    public static void addGiantBogshrooms(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.GIANT_BOGSHROOMS);
    }

    public static void addDarkWillowTrees(BiomeGenerationSettings.Builder builder, boolean sparse) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, sparse ? MnPlacedFeatures.DARK_WILLOW_TREES_RARE : MnPlacedFeatures.DARK_WILLOW_TREES);
    }

    public static void addShadowrootTrees(BiomeGenerationSettings.Builder builder, boolean sparse) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, sparse ? MnPlacedFeatures.SHADOWROOT_TREES_SPARSE : MnPlacedFeatures.SHADOWROOT_TREES_DENSE);
    }

    public static void addTallShadowrootTrees(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.SHADOWROOT_TREES_TALL_DENSE);
    }

    public static void addDeadWood(BiomeGenerationSettings.Builder builder, boolean sparse) {
        if (sparse) {
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.DEAD_LOG_RARE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.DEAD_STUMP_RARE);
        } else {
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.DEAD_LOG_COMMON);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.DEAD_STUMP_COMMON);
        }
    }

    public static void addSuavis(BiomeGenerationSettings.Builder builder, boolean sparse) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, sparse ? MnPlacedFeatures.SUAVIS_RARE : MnPlacedFeatures.SUAVIS_COMMON);
    }

    public static void addTendrilweed(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.TENDRILWEED);
    }

    public static void addMalignantPlants(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.MALIGNANT_PLANTS);
    }

    public static void addNightshrooms(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.NIGHTSHROOMS);
    }

    public static void addDewshrooms(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.DEWSHROOMS);
    }

    public static void addViridshrooms(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.VIRIDSHROOMS);
    }

    public static void addMistshrooms(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.MISTSHROOMS);
    }

    public static void addMoonshrooms(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.MOONSHROOMS);
    }

    public static void addGenericForestVegetationNoGrove(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.NIGHTSHROOM_RING);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.NIGHTSHROOMS_SPARSE);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.UNSTABLE_BUSH);
    }

    public static void addGenericForestVegetation(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.BLADESHROOMS);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.LUMEN_BUDS);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.DRAGONS_NEST);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.VIOLEAFS);
    }

    public static void addDeadForestPlants(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.DEAD_SAPLING);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.BLADESHROOMS);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.DRAGONS_NEST);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.VIOLEAFS);
    }

    public static void addSwampPlants(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.NIGHT_REEDS_COMMON);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.BOGSHROOMS);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.BOGWEED);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.DECEITFUL_ALGAE);
    }

    public static void addGhostPlants(BiomeGenerationSettings.Builder builder, boolean sparse) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, sparse ? MnPlacedFeatures.GHOST_PLANTS_SPARSE : MnPlacedFeatures.GHOST_PLANTS);
    }

    public static void addSmallGrass(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.GRASS_FOREST);
    }

    public static void addRunebushes(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.RUNEBUSHES);
    }

    public static void addCrystalFlowers(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.CRYSTAL_FLOWERS);
    }

    public static void addMarshGrasses(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.TALL_GRASS_MARSH);
    }

    public static void addBigGrass(BiomeGenerationSettings.Builder builder) {
        MnBiomeDefaultFeatures.addBigGrass(builder, true);
    }

    public static void addBigGrass(BiomeGenerationSettings.Builder builder, boolean dense) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.FINGERED_GRASS);
        if (dense) {
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.TALL_GRASS_PLAIN_DENSE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.GRASS_PLAIN_DENSE);
        } else {
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.TALL_GRASS_PLAIN);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MnPlacedFeatures.GRASS_PLAIN);
        }
    }

    public static void addUmbraflame(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, MnPlacedFeatures.UMBRAFLAME_PATCH);
    }

    public static void addStingerEggs(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, MnPlacedFeatures.STINGER_EGGS);
    }

    public static void addCrystalotuses(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, MnPlacedFeatures.CRYSTALOTUS);
    }

    public static void addRuins(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, MnPlacedFeatures.SMALL_RUIN);
    }

    public static void addDenseForestAnimals(MobSpawnSettings.Builder builder) {
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)MnEntityTypes.NIGHTSTAG.get(), 10, 2, 4));
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)MnEntityTypes.SLINK.get(), 8, 1, 3));
    }

    public static void addSparseForestAnimals(MobSpawnSettings.Builder builder) {
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)MnEntityTypes.NIGHTSTAG.get(), 8, 2, 4));
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)MnEntityTypes.SLINK.get(), 8, 1, 3));
    }

    public static void addPlainsAnimals(MobSpawnSettings.Builder builder) {
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)MnEntityTypes.NIGHTSTAG.get(), 5, 1, 3));
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)MnEntityTypes.SLINK.get(), 5, 1, 3));
    }

    public static void monsters(MobSpawnSettings.Builder builder) {
        builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)MnEntityTypes.RIFTER.get(), 50, 1, 1));
        builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)MnEntityTypes.NIGHTSHADE.get(), 5, 1, 1));
        builder.m_48370_((EntityType)MnEntityTypes.RIFTER.get(), 0.7, 0.15);
        builder.m_48370_((EntityType)MnEntityTypes.NIGHTSHADE.get(), 0.7, 0.15);
    }

    public static void malignantSurfaceMonsters(MobSpawnSettings.Builder builder) {
        builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)MnEntityTypes.RIFTER.get(), 50, 2, 4));
        builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)MnEntityTypes.NIGHTSHADE.get(), 5, 1, 1));
        builder.m_48370_((EntityType)MnEntityTypes.RIFTER.get(), 0.7, 0.15);
        builder.m_48370_((EntityType)MnEntityTypes.NIGHTSHADE.get(), 0.7, 0.15);
    }
}

