/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.biome.factory.surface;

import com.crypticmushroom.minecraft.midnight.common.registry.MnParticleTypes;
import com.crypticmushroom.minecraft.midnight.common.world.biome.effects.MidnightBiomeModifier;
import com.crypticmushroom.minecraft.midnight.common.world.biome.factory.MnBiomeFactory;
import com.crypticmushroom.minecraft.midnight.common.world.biome.util.MnBiomeDefaultFeatures;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;

public final class FungiForestFactory
extends MnBiomeFactory {
    @Override
    public BiomeSpecialEffects.Builder specialEffects(BootstapContext<Biome> bootstrap) {
        return super.specialEffects(bootstrap).m_48029_(new AmbientParticleSettings((ParticleOptions)MnParticleTypes.AMBIENT_SPORE.get(), 0.005f)).m_48019_(1320747);
    }

    @Override
    public MidnightBiomeModifier.Builder customEffects(BootstapContext<Biome> bootstrap) {
        return super.customEffects(bootstrap).nightGrassColor(5850283);
    }

    @Override
    public MobSpawnSettings.Builder mobSpawnSettings(BootstapContext<Biome> bootstrap) {
        MobSpawnSettings.Builder builder = super.mobSpawnSettings(bootstrap);
        MnBiomeDefaultFeatures.addSparseForestAnimals(builder);
        MnBiomeDefaultFeatures.monsters(builder);
        return builder;
    }

    @Override
    public BiomeGenerationSettings.Builder defaultGenerationSettingsBuilder(BootstapContext<Biome> bootstrap) {
        BiomeGenerationSettings.Builder builder = super.defaultGenerationSettingsBuilder(bootstrap);
        MnBiomeDefaultFeatures.addOres(builder);
        MnBiomeDefaultFeatures.addLowCorruptionFeatures(builder);
        MnBiomeDefaultFeatures.addShadowrootTrees(builder, true);
        MnBiomeDefaultFeatures.addFungiForestVegetation(builder);
        MnBiomeDefaultFeatures.addGhostPlants(builder, true);
        MnBiomeDefaultFeatures.addSmallGrass(builder);
        MnBiomeDefaultFeatures.addRuins(builder);
        return builder;
    }
}

