/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.biome;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBiomes;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;

public class MnBiomeMapBuilder {
    private final Climate.Parameter FULL_RANGE = MnBiomeMapBuilder.span(-1.0f, 1.0f);
    private final Climate.Parameter fartherOceanContRange = MnBiomeMapBuilder.span(-1.0f, -0.6f);
    private final Climate.Parameter nearerOceanContRange = MnBiomeMapBuilder.span(-0.6f, -0.5f);
    private final Climate.Parameter entireLandRange = MnBiomeMapBuilder.span(-0.5f, 1.0f);
    private final Climate.Parameter nearCoastRange = MnBiomeMapBuilder.span(-0.5f, 0.0f);
    private final Climate.Parameter farInlandRange = MnBiomeMapBuilder.span(0.0f, 1.0f);
    private final Climate.Parameter coastRange = MnBiomeMapBuilder.span(-0.5f, -0.35f);
    private final Climate.Parameter landRangeNoCoast = MnBiomeMapBuilder.span(-0.35f, 1.0f);
    private final Climate.Parameter[] corruptionRanges = new Climate.Parameter[]{MnBiomeMapBuilder.span(-1.0f, -0.25f), MnBiomeMapBuilder.span(-0.25f, -0.05f), MnBiomeMapBuilder.span(-0.05f, 0.15f), MnBiomeMapBuilder.span(0.15f, 0.3f), MnBiomeMapBuilder.span(0.3f, 1.0f)};
    private final Climate.Parameter[] vegetationRanges = new Climate.Parameter[]{MnBiomeMapBuilder.span(-1.0f, -0.35f), MnBiomeMapBuilder.span(-0.35f, -0.2f), MnBiomeMapBuilder.span(-0.2f, -0.05f), MnBiomeMapBuilder.span(-0.05f, 0.15f), MnBiomeMapBuilder.span(0.15f, 0.35f), MnBiomeMapBuilder.span(0.35f, 1.0f)};
    private final Climate.Parameter[] erosions = new Climate.Parameter[]{MnBiomeMapBuilder.span(-1.0f, -0.49f), MnBiomeMapBuilder.span(-0.49f, -0.4f), MnBiomeMapBuilder.span(-0.4f, -0.29f), MnBiomeMapBuilder.span(-0.29f, -0.22f), MnBiomeMapBuilder.span(-0.22f, 0.22f), MnBiomeMapBuilder.span(0.22f, 0.29f), MnBiomeMapBuilder.span(0.29f, 0.4f), MnBiomeMapBuilder.span(0.4f, 0.48f), MnBiomeMapBuilder.span(0.48f, 1.0f)};
    private final Climate.Parameter[] erosionIndex1Subdivision = new Climate.Parameter[]{MnBiomeMapBuilder.span(-0.48f, -0.46f), MnBiomeMapBuilder.span(-0.46f, -0.42f), MnBiomeMapBuilder.span(-0.42f, -0.4f)};
    private final Climate.Parameter[] erosionIndex7Subdivision = new Climate.Parameter[]{MnBiomeMapBuilder.span(0.4f, 0.42f), MnBiomeMapBuilder.span(0.42f, 0.46f), MnBiomeMapBuilder.span(0.46f, 0.48f)};
    private final ResourceKey<Biome>[][] highlandBiomes = new ResourceKey[][]{{MnBiomes.NIGHT_PLAINS, MnBiomes.NIGHT_PLAINS, MnBiomes.NIGHT_PLAINS, MnBiomes.VIGILANT_FOREST, MnBiomes.TOWERING_VIGILANT_FOREST, MnBiomes.TOWERING_VIGILANT_FOREST}, {MnBiomes.NIGHT_PLAINS, MnBiomes.NIGHT_PLAINS, MnBiomes.NIGHT_PLAINS, MnBiomes.VIGILANT_FOREST, MnBiomes.TOWERING_VIGILANT_FOREST, MnBiomes.TOWERING_VIGILANT_FOREST}, {MnBiomes.DEAD_FOREST, MnBiomes.DEAD_FOREST, MnBiomes.NIGHT_PLAINS, MnBiomes.VIGILANT_FOREST, MnBiomes.TOWERING_VIGILANT_FOREST, MnBiomes.TOWERING_VIGILANT_FOREST}, {MnBiomes.NIGHT_PLAINS, MnBiomes.NIGHT_PLAINS, MnBiomes.NIGHT_PLAINS, MnBiomes.VIGILANT_FOREST, MnBiomes.TOWERING_VIGILANT_FOREST, MnBiomes.TOWERING_VIGILANT_FOREST}, {MnBiomes.MALIGNANT_GRASSLAND, MnBiomes.MALIGNANT_GRASSLAND, MnBiomes.MALIGNANT_GRASSLAND, MnBiomes.MALIGNANT_GRASSLAND, MnBiomes.MALEVOLENT_FOREST, MnBiomes.MALEVOLENT_FOREST}};
    private final ResourceKey<Biome>[][] lowlandBiomes = new ResourceKey[][]{{MnBiomes.CRYSTAL_SPIRES, MnBiomes.CRYSTAL_SPIRES, MnBiomes.NIGHT_PLAINS, MnBiomes.VIGILANT_FOREST, MnBiomes.FUNGI_FOREST, MnBiomes.FUNGI_FOREST}, {MnBiomes.NIGHT_PLAINS, MnBiomes.NIGHT_PLAINS, MnBiomes.NIGHT_PLAINS, MnBiomes.VIGILANT_FOREST, MnBiomes.FUNGI_FOREST, MnBiomes.FUNGI_FOREST}, {MnBiomes.DEAD_FOREST, MnBiomes.DEAD_FOREST, MnBiomes.NIGHT_PLAINS, MnBiomes.VIGILANT_FOREST, MnBiomes.VIGILANT_FOREST, MnBiomes.TOWERING_VIGILANT_FOREST}, {MnBiomes.NIGHT_PLAINS, MnBiomes.NIGHT_PLAINS, MnBiomes.NIGHT_PLAINS, MnBiomes.VIGILANT_FOREST, MnBiomes.VIGILANT_FOREST, MnBiomes.TOWERING_VIGILANT_FOREST}, {MnBiomes.MALIGNANT_GRASSLAND, MnBiomes.MALIGNANT_GRASSLAND, MnBiomes.MALIGNANT_GRASSLAND, MnBiomes.MALIGNANT_GRASSLAND, MnBiomes.MALEVOLENT_FOREST, MnBiomes.MALEVOLENT_FOREST}};

    public void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair) {
        this.addUndergroundBiomes(consumerPair);
        this.addOffcoastBiomes(consumerPair);
        this.addInlandBiomes(consumerPair);
    }

    private void addOffcoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair) {
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, MnBiomeMapBuilder.span(-0.36f, 0.36f), this.FULL_RANGE, this.fartherOceanContRange, 0.0f, MnBiomes.DARK_OCEAN);
        for (int i = 0; i < this.corruptionRanges.length; ++i) {
            for (int j = 0; j < this.vegetationRanges.length; ++j) {
                Climate.Parameter corruption = this.corruptionRanges[i];
                Climate.Parameter vegetation = this.vegetationRanges[j];
                ResourceKey<Biome> lowlandBiome = this.pickLowlandBiome(i, j);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, MnBiomeMapBuilder.span(-1.0f, -0.36f), this.FULL_RANGE, this.fartherOceanContRange, 0.0f, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, MnBiomeMapBuilder.span(0.36f, 1.0f), this.FULL_RANGE, this.fartherOceanContRange, 0.0f, lowlandBiome);
            }
        }
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, this.nearerOceanContRange, 0.0f, MnBiomes.DARK_OCEAN);
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair) {
        this.fillMidSlice(consumerPair, MnBiomeMapBuilder.span(-1.0f, -0.93333334f));
        this.fillHighSlice(consumerPair, MnBiomeMapBuilder.span(-0.93333334f, -0.7666667f));
        this.fillPeakSlice(consumerPair, MnBiomeMapBuilder.span(-0.7666667f, -0.56666666f));
        this.fillHighSlice(consumerPair, MnBiomeMapBuilder.span(-0.56666666f, -0.4f));
        this.fillMidSlice(consumerPair, MnBiomeMapBuilder.span(-0.4f, -0.26666668f));
        this.fillLowSlice(consumerPair, MnBiomeMapBuilder.span(-0.26666668f, -0.1f));
        this.fillVeryLowSlice(consumerPair, MnBiomeMapBuilder.span(-0.1f, -0.05f));
        this.fillValleySlice(consumerPair, MnBiomeMapBuilder.span(-0.05f, 0.05f));
        this.fillVeryLowSlice(consumerPair, MnBiomeMapBuilder.span(0.05f, 0.1f));
        this.fillLowSlice(consumerPair, MnBiomeMapBuilder.span(0.1f, 0.26666668f));
        this.fillMidSlice(consumerPair, MnBiomeMapBuilder.span(0.26666668f, 0.4f));
        this.fillHighSlice(consumerPair, MnBiomeMapBuilder.span(0.4f, 0.56666666f));
        this.fillPeakSlice(consumerPair, MnBiomeMapBuilder.span(0.56666666f, 0.7666667f));
        this.fillHighSlice(consumerPair, MnBiomeMapBuilder.span(0.7666667f, 0.93333334f));
        this.fillMidSlice(consumerPair, MnBiomeMapBuilder.span(0.93333334f, 1.0f));
    }

    private void fillPeakSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair, Climate.Parameter weirdnessRange) {
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[0], this.entireLandRange, MnBiomes.OBSCURED_PLATEAU);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[2], this.entireLandRange, MnBiomes.BLACK_RIDGE);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[4], this.entireLandRange, MnBiomes.OBSCURED_PEAKS);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[6], this.entireLandRange, MnBiomes.BLACK_RIDGE);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[8], this.entireLandRange, MnBiomes.WARPED_FIELDS);
        for (int i = 0; i < this.corruptionRanges.length; ++i) {
            for (int j = 0; j < this.vegetationRanges.length; ++j) {
                Climate.Parameter corruption = this.corruptionRanges[i];
                Climate.Parameter vegetation = this.vegetationRanges[j];
                ResourceKey<Biome> highlandBiome = this.pickHighlandBiome(i, j);
                ResourceKey<Biome> lowlandBiome = this.pickLowlandBiome(i, j);
                ResourceKey<Biome> maybeRunebushGrove = this.maybePickRunebushGrove(lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosionIndex1Subdivision[0], this.entireLandRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosionIndex1Subdivision[1], this.entireLandRange, maybeRunebushGrove);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosionIndex1Subdivision[2], this.entireLandRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[3], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[5], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosionIndex7Subdivision[0], this.entireLandRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosionIndex7Subdivision[1], this.entireLandRange, maybeRunebushGrove);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosionIndex7Subdivision[2], this.entireLandRange, lowlandBiome);
            }
        }
    }

    private void fillHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair, Climate.Parameter weirdnessRange) {
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[0], this.entireLandRange, MnBiomes.OBSCURED_PLATEAU);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[2], this.entireLandRange, MnBiomes.BLACK_RIDGE);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[4], this.entireLandRange, MnBiomes.OBSCURED_PEAKS);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[6], this.entireLandRange, MnBiomes.BLACK_RIDGE);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[8], this.entireLandRange, MnBiomes.WARPED_FIELDS);
        for (int i = 0; i < this.corruptionRanges.length; ++i) {
            for (int j = 0; j < this.vegetationRanges.length; ++j) {
                Climate.Parameter corruption = this.corruptionRanges[i];
                Climate.Parameter vegetation = this.vegetationRanges[j];
                ResourceKey<Biome> highlandBiome = this.pickHighlandBiome(i, j);
                ResourceKey<Biome> lowlandBiome = this.pickLowlandBiome(i, j);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[1], this.entireLandRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[3], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[5], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[7], this.entireLandRange, lowlandBiome);
            }
        }
    }

    private void fillMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair, Climate.Parameter weirdnessRange) {
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[0], this.entireLandRange, MnBiomes.OBSCURED_PLATEAU);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[8], this.entireLandRange, MnBiomes.WARPED_FIELDS);
        for (int i = 0; i < this.corruptionRanges.length; ++i) {
            for (int j = 0; j < this.vegetationRanges.length; ++j) {
                Climate.Parameter corruption = this.corruptionRanges[i];
                Climate.Parameter vegetation = this.vegetationRanges[j];
                ResourceKey<Biome> highlandBiome = this.pickHighlandBiome(i, j);
                ResourceKey<Biome> lowlandBiome = this.pickLowlandBiome(i, j);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[1], this.entireLandRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[2], this.entireLandRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[3], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[4], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[5], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[6], this.entireLandRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[7], this.entireLandRange, lowlandBiome);
            }
        }
    }

    private void fillLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair, Climate.Parameter weirdnessRange) {
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[0], this.entireLandRange, MnBiomes.PHANTASMAL_VALLEY);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[8], this.entireLandRange, MnBiomes.WARPED_FIELDS);
        for (int i = 0; i < this.corruptionRanges.length; ++i) {
            for (int j = 0; j < this.vegetationRanges.length; ++j) {
                Climate.Parameter corruption = this.corruptionRanges[i];
                Climate.Parameter vegetation = this.vegetationRanges[j];
                ResourceKey<Biome> highlandBiome = this.pickHighlandBiome(i, j);
                ResourceKey<Biome> lowlandBiome = this.pickLowlandBiome(i, j);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[1], this.entireLandRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[2], this.coastRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[2], this.landRangeNoCoast, MnBiomes.DECEITFUL_SWAMP);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[3], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[4], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[5], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[6], this.entireLandRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[7], this.coastRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[7], this.landRangeNoCoast, MnBiomes.DECEITFUL_MARSH);
            }
        }
    }

    private void fillVeryLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair, Climate.Parameter weirdnessRange) {
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[0], this.entireLandRange, MnBiomes.PHANTASMAL_VALLEY);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[8], this.entireLandRange, MnBiomes.WARPED_FIELDS);
        for (int i = 0; i < this.corruptionRanges.length; ++i) {
            for (int j = 0; j < this.vegetationRanges.length; ++j) {
                Climate.Parameter corruption = this.corruptionRanges[i];
                Climate.Parameter vegetation = this.vegetationRanges[j];
                ResourceKey<Biome> highlandBiome = this.pickHighlandBiome(i, j);
                ResourceKey<Biome> lowlandBiome = this.pickLowlandBiome(i, j);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[1], this.entireLandRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[2], this.coastRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[2], this.landRangeNoCoast, MnBiomes.DECEITFUL_SWAMP);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[3], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[4], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[5], this.entireLandRange, highlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[6], this.entireLandRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[7], this.coastRange, lowlandBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[7], this.landRangeNoCoast, MnBiomes.DECEITFUL_MARSH);
            }
        }
    }

    private void fillValleySlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair, Climate.Parameter weirdnessRange) {
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[0], this.entireLandRange, MnBiomes.PHANTASMAL_VALLEY);
        this.addSurfaceBiome(consumerPair, this.FULL_RANGE, this.FULL_RANGE, weirdnessRange, this.erosions[8], this.entireLandRange, MnBiomes.WARPED_FIELDS);
        for (int i = 0; i < this.corruptionRanges.length; ++i) {
            for (int j = 0; j < this.vegetationRanges.length; ++j) {
                Climate.Parameter corruption = this.corruptionRanges[i];
                Climate.Parameter vegetation = this.vegetationRanges[j];
                ResourceKey<Biome> highlandBiome = this.pickHighlandBiome(i, j);
                ResourceKey<Biome> saddleValleyBiome = this.maybePickVigilantValley(highlandBiome);
                ResourceKey<Biome> riverBiome = MnBiomes.DARK_RIVER;
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[1], this.entireLandRange, riverBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[2], this.coastRange, riverBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[2], this.landRangeNoCoast, MnBiomes.DECEITFUL_SWAMP);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[3], this.entireLandRange, riverBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[4], this.nearCoastRange, riverBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[4], this.farInlandRange, saddleValleyBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[5], this.entireLandRange, riverBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[6], this.entireLandRange, riverBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[7], this.coastRange, riverBiome);
                this.addSurfaceBiome(consumerPair, corruption, vegetation, weirdnessRange, this.erosions[7], this.landRangeNoCoast, MnBiomes.DECEITFUL_MARSH);
            }
        }
    }

    private void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
        Climate.Parameter upperDepth = MnBiomeMapBuilder.span(0.2f, 0.55f);
        Climate.Parameter lowerDepth = MnBiomeMapBuilder.span(0.55f, 1.0f);
        Climate.Parameter cavernsCont = MnBiomeMapBuilder.span(-1.0f, 0.0f);
        Climate.Parameter greaterCavernsCont = MnBiomeMapBuilder.span(0.0f, 0.6f);
        Climate.Parameter rouxeCavernsCont = MnBiomeMapBuilder.span(0.6f, 1.0f);
        this.addUndergroundBiome(consumer, upperDepth, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, MnBiomes.CAVERNS);
        this.addUndergroundBiome(consumer, lowerDepth, this.FULL_RANGE, MnBiomeMapBuilder.span(-1.0f, 0.2f), this.FULL_RANGE, this.FULL_RANGE, cavernsCont, MnBiomes.CAVERNS);
        this.addUndergroundBiome(consumer, lowerDepth, this.FULL_RANGE, MnBiomeMapBuilder.span(0.2f, 1.0f), this.FULL_RANGE, this.FULL_RANGE, cavernsCont, MnBiomes.FUNGAL_CAVERNS);
        this.addUndergroundBiome(consumer, lowerDepth, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, greaterCavernsCont, MnBiomes.GREATER_CAVERNS);
        this.addUndergroundBiome(consumer, lowerDepth, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, rouxeCavernsCont, MnBiomes.ROUXE_CAVERNS);
    }

    private ResourceKey<Biome> pickHighlandBiome(int corruptionIndex, int vegetationIndex) {
        return this.highlandBiomes[corruptionIndex][vegetationIndex];
    }

    private ResourceKey<Biome> pickLowlandBiome(int corruptionIndex, int vegetationIndex) {
        return this.lowlandBiomes[corruptionIndex][vegetationIndex];
    }

    private ResourceKey<Biome> maybePickRunebushGrove(ResourceKey<Biome> biome) {
        return biome == MnBiomes.VIGILANT_FOREST ? MnBiomes.RUNEBUSH_GROVE : biome;
    }

    private ResourceKey<Biome> maybePickVigilantValley(ResourceKey<Biome> biome) {
        return biome == MnBiomes.VIGILANT_FOREST || biome == MnBiomes.TOWERING_VIGILANT_FOREST ? MnBiomes.VIGILANT_GLADE : biome;
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair, Climate.Parameter corruption, Climate.Parameter vegetation, Climate.Parameter weirdness, Climate.Parameter erosion, Climate.Parameter continentalness, ResourceKey<Biome> biome) {
        consumerPair.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)corruption, (Climate.Parameter)vegetation, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186822_((float)0.0f, (float)0.2f), (Climate.Parameter)weirdness, (float)0.0f), biome));
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair, Climate.Parameter corruption, Climate.Parameter vegetation, Climate.Parameter weirdness, Climate.Parameter erosion, Climate.Parameter continentalness, float offset, ResourceKey<Biome> biome) {
        consumerPair.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)corruption, (Climate.Parameter)vegetation, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186822_((float)0.0f, (float)0.2f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    private void addUndergroundBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumerPair, Climate.Parameter depth, Climate.Parameter corruption, Climate.Parameter vegetation, Climate.Parameter weirdness, Climate.Parameter erosion, Climate.Parameter continentalness, ResourceKey<Biome> biome) {
        consumerPair.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)corruption, (Climate.Parameter)vegetation, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)depth, (Climate.Parameter)weirdness, (float)0.0f), biome));
    }

    private static Climate.Parameter span(float min, float max) {
        return Climate.Parameter.m_186822_((float)min, (float)max);
    }

    private static Climate.Parameter span(Climate.Parameter min, Climate.Parameter max) {
        return Climate.Parameter.m_186829_((Climate.Parameter)min, (Climate.Parameter)max);
    }

    private static Climate.Parameter point(float point) {
        return Climate.Parameter.m_186820_((float)point);
    }
}

