/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.registry.builder;

import com.crypticmushroom.minecraft.midnight.common.registry.MnRegistry;
import com.crypticmushroom.minecraft.midnight.common.registry.builder.MnBiomeModifierBuilder;
import com.crypticmushroom.minecraft.midnight.common.world.biome.effects.MidnightBiomeModifier;
import com.crypticmushroom.minecraft.midnight.common.world.biome.factory.MnBiomeFactory;
import com.crypticmushroom.minecraft.registry.builder.minecraft.BiomeBuilder;
import com.crypticmushroom.minecraft.registry.data.resource.DataResourceRegister;
import it.unimi.dsi.fastutil.objects.Object2BooleanFunction;
import it.unimi.dsi.fastutil.objects.Object2FloatFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;

public final class MnBiomeBuilder
extends BiomeBuilder<MnBiomeBuilder> {
    private final MnBiomeFactory factory;

    public MnBiomeBuilder(Supplier<MnBiomeFactory> factory) {
        this.factory = factory.get();
    }

    protected DataResourceRegister<Biome> getRegister() {
        return MnRegistry.BIOMES;
    }

    protected Biome buildType(BootstapContext<Biome> bootstrap) {
        this.factory.apply(bootstrap, this);
        ((MnBiomeModifierBuilder)new MnBiomeModifierBuilder<MidnightBiomeModifier>(() -> this.factory.customEffects(bootstrap).build((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)this.makeResLoc()))).id(this.getId())).build();
        return super.buildType(bootstrap);
    }

    @Deprecated(forRemoval=true)
    public MnBiomeBuilder precipitation(Biome.Precipitation precipitation) {
        return (MnBiomeBuilder)super.precipitation(precipitation);
    }

    @Deprecated
    public MnBiomeBuilder hasPrecipitation(boolean hasPercipitation) {
        return (MnBiomeBuilder)super.hasPrecipitation(hasPercipitation);
    }

    @Deprecated
    public MnBiomeBuilder hasPrecipitation(BooleanSupplier hasPrecipitation) {
        return (MnBiomeBuilder)super.hasPrecipitation(hasPrecipitation);
    }

    @Deprecated
    public MnBiomeBuilder hasPrecipitation(Object2BooleanFunction<BootstapContext<Biome>> hasPrecipitation) {
        return (MnBiomeBuilder)super.hasPrecipitation(hasPrecipitation);
    }

    @Deprecated
    public MnBiomeBuilder temperature(float temperature) {
        return (MnBiomeBuilder)super.temperature(temperature);
    }

    @Deprecated
    public MnBiomeBuilder temperature(Supplier<Float> temperature) {
        return (MnBiomeBuilder)super.temperature(temperature);
    }

    @Deprecated
    public MnBiomeBuilder temperature(Object2FloatFunction<BootstapContext<Biome>> temperature) {
        return (MnBiomeBuilder)super.temperature(temperature);
    }

    @Deprecated
    public MnBiomeBuilder downfall(float downfall) {
        return (MnBiomeBuilder)super.downfall(downfall);
    }

    @Deprecated
    public MnBiomeBuilder downfall(Supplier<Float> downfall) {
        return (MnBiomeBuilder)super.downfall(downfall);
    }

    @Deprecated
    public MnBiomeBuilder downfall(Object2FloatFunction<BootstapContext<Biome>> downfall) {
        return (MnBiomeBuilder)super.downfall(downfall);
    }

    @Deprecated
    public MnBiomeBuilder specialEffects(BiomeSpecialEffects effects) {
        return (MnBiomeBuilder)super.specialEffects(effects);
    }

    @Deprecated
    public MnBiomeBuilder specialEffects(Supplier<BiomeSpecialEffects> effects) {
        return (MnBiomeBuilder)super.specialEffects(effects);
    }

    @Deprecated
    public MnBiomeBuilder specialEffects(Function<BootstapContext<Biome>, BiomeSpecialEffects> effects) {
        return (MnBiomeBuilder)super.specialEffects(effects);
    }

    @Deprecated
    public MnBiomeBuilder mobSpawnSettings(MobSpawnSettings mobSpawnSettings) {
        return (MnBiomeBuilder)super.mobSpawnSettings(mobSpawnSettings);
    }

    @Deprecated
    public MnBiomeBuilder mobSpawnSettings(Supplier<MobSpawnSettings> mobSpawnSettings) {
        return (MnBiomeBuilder)super.mobSpawnSettings(mobSpawnSettings);
    }

    @Deprecated
    public MnBiomeBuilder mobSpawnSettings(Function<BootstapContext<Biome>, MobSpawnSettings> mobSpawnSettings) {
        return (MnBiomeBuilder)super.mobSpawnSettings(mobSpawnSettings);
    }

    @Deprecated
    public MnBiomeBuilder generationSettings(BiomeGenerationSettings generationSettings) {
        return (MnBiomeBuilder)super.generationSettings(generationSettings);
    }

    @Deprecated
    public MnBiomeBuilder generationSettings(Supplier<BiomeGenerationSettings> generationSettings) {
        return (MnBiomeBuilder)super.generationSettings(generationSettings);
    }

    @Deprecated
    public MnBiomeBuilder generationSettings(Function<BootstapContext<Biome>, BiomeGenerationSettings> generationSettings) {
        return (MnBiomeBuilder)super.generationSettings(generationSettings);
    }

    @Deprecated
    public MnBiomeBuilder temperatureAdjustment(Biome.TemperatureModifier temperatureSettings) {
        return (MnBiomeBuilder)super.temperatureAdjustment(temperatureSettings);
    }

    @Deprecated
    public MnBiomeBuilder temperatureAdjustment(Supplier<Biome.TemperatureModifier> temperatureSettings) {
        return (MnBiomeBuilder)super.temperatureAdjustment(temperatureSettings);
    }

    @Deprecated
    public MnBiomeBuilder temperatureAdjustment(Function<BootstapContext<Biome>, Biome.TemperatureModifier> temperatureSettings) {
        return (MnBiomeBuilder)super.temperatureAdjustment(temperatureSettings);
    }
}

