/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.registry;

import com.crypticmushroom.minecraft.midnight.common.block.plant.HangingLeavesBushBlock;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnRegistry;
import com.crypticmushroom.minecraft.midnight.common.registry.MnStructureProcessorTypes;
import com.crypticmushroom.minecraft.midnight.common.world.gen.processor.HangingLeavesProcessor;
import com.crypticmushroom.minecraft.midnight.common.world.gen.processor.NoiseDisintegrationProcessor;
import com.crypticmushroom.minecraft.midnight.common.world.gen.processor.StateProviderReplacementProcessor;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class MnStructureProcessorLists {
    public static final ResourceKey<StructureProcessorList> RUIN_NO_DISINTEGRATION = MnStructureProcessorLists.key("ruin_no_disintegration");
    public static final ResourceKey<StructureProcessorList> RUIN_SMALL_DISINTEGRATION = MnStructureProcessorLists.key("ruin_small_disintegration");
    public static final ResourceKey<StructureProcessorList> RUIN_BIG_DISINTEGRATION = MnStructureProcessorLists.key("ruin_big_disintegration");
    public static final ResourceKey<StructureProcessorList> DARK_WILLOW_TREE = MnStructureProcessorLists.key("dark_willow_tree");
    public static final ResourceKey<StructureProcessorList> STONE_DEGRADATION = MnStructureProcessorLists.key("stone_degradation");

    private static ResourceKey<StructureProcessorList> key(String name) {
        return MnRegistry.STRUCTURE_PROCESSOR_LISTS.key(name);
    }

    private static Holder<StructureProcessorList> register(BootstapContext<StructureProcessorList> ctx, ResourceKey<StructureProcessorList> key, StructureProcessor ... processors) {
        return MnStructureProcessorLists.register(ctx, key, new StructureProcessorList(List.of(processors)));
    }

    private static Holder<StructureProcessorList> register(BootstapContext<StructureProcessorList> ctx, ResourceKey<StructureProcessorList> key, List<? extends StructureProcessor> processors) {
        return MnStructureProcessorLists.register(ctx, key, new StructureProcessorList(List.copyOf(processors)));
    }

    private static Holder<StructureProcessorList> register(BootstapContext<StructureProcessorList> ctx, ResourceKey<StructureProcessorList> key, StructureProcessorList list) {
        return MnRegistry.STRUCTURE_PROCESSOR_LISTS.register(ctx, key, (Object)list);
    }

    static void bootstrap(BootstapContext<StructureProcessorList> ctx) {
        MnStructureProcessorLists.register(ctx, RUIN_NO_DISINTEGRATION, new StateProviderReplacementProcessor((Block)MnBlocks.NIGHT_GRASS_BLOCK.get(), (BlockStateProvider)MnStructureProcessorTypes.FLOOR_PROVIDER.get()), (StructureProcessor)MnStructureProcessorTypes.CRACKED_BLOCK_RULE_PROCESSOR.get());
        MnStructureProcessorLists.register(ctx, RUIN_SMALL_DISINTEGRATION, new NoiseDisintegrationProcessor(0.0, new NormalNoise.NoiseParameters(-1, 1.0, new double[0])), (StructureProcessor)MnStructureProcessorTypes.CRACKED_BLOCK_RULE_PROCESSOR.get());
        MnStructureProcessorLists.register(ctx, RUIN_BIG_DISINTEGRATION, new NoiseDisintegrationProcessor(0.0, new NormalNoise.NoiseParameters(-3, 1.0, new double[]{0.5, 0.5})), (StructureProcessor)MnStructureProcessorTypes.CRACKED_BLOCK_RULE_PROCESSOR.get());
        MnStructureProcessorLists.register(ctx, DARK_WILLOW_TREE, new HangingLeavesProcessor(2, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MnBlocks.HANGING_DARK_WILLOW_LEAVES.get())), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((BlockState)((HangingLeavesBushBlock)MnBlocks.HANGING_DARK_WILLOW_LEAVES.get()).m_49966_().m_61124_((Property)HangingLeavesBushBlock.END, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HangingLeavesBushBlock.ROOT, (Comparable)Boolean.valueOf(false))))));
        MnStructureProcessorLists.register(ctx, STONE_DEGRADATION, (StructureProcessor)MnStructureProcessorTypes.CRACKED_BLOCK_RULE_PROCESSOR.get());
    }
}

