/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.registry;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnConfiguredFeatures;
import com.crypticmushroom.minecraft.midnight.common.registry.MnRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.TrapezoidHeight;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public final class MnPlacedFeatures {
    public static final ResourceKey<PlacedFeature> PIT = MnPlacedFeatures.key("pit");
    public static final ResourceKey<PlacedFeature> TRENCHSTONE_BOULDER = MnPlacedFeatures.key("trenchstone_boulder");
    public static final ResourceKey<PlacedFeature> NIGHTSTONE_BOULDER = MnPlacedFeatures.key("nightstone_boulder");
    public static final ResourceKey<PlacedFeature> NIGHTSTONE_SPIKE = MnPlacedFeatures.key("nightstone_spike");
    public static final ResourceKey<PlacedFeature> BLOOMCRYSTAL_CLUSTERS = MnPlacedFeatures.key("bloomcrystal_clusters");
    public static final ResourceKey<PlacedFeature> ROCKSHROOM_HEAP = MnPlacedFeatures.key("rockshroom_heap");
    public static final ResourceKey<PlacedFeature> VIRILUX_CAVE = MnPlacedFeatures.key("virilux_cave");
    public static final ResourceKey<PlacedFeature> WATER_DELTA = MnPlacedFeatures.key("water_delta");
    public static final ResourceKey<PlacedFeature> MALIGNANT_PATCH_COMMON = MnPlacedFeatures.key("malignant_patch_common");
    public static final ResourceKey<PlacedFeature> MALIGNANT_PATCH_UNCOMMON = MnPlacedFeatures.key("malignant_patch_uncommon");
    public static final ResourceKey<PlacedFeature> MALIGNANT_PATCH_RARE = MnPlacedFeatures.key("malignant_patch_rare");
    public static final ResourceKey<PlacedFeature> EBONITE_ORE = MnPlacedFeatures.key("ebonite_ore");
    public static final ResourceKey<PlacedFeature> NAGRILITE_ORE = MnPlacedFeatures.key("nagrilite_ore");
    public static final ResourceKey<PlacedFeature> NAGRILITE_ORE_WIDE = MnPlacedFeatures.key("nagrilite_ore_wide");
    public static final ResourceKey<PlacedFeature> TENEBRUM_ORE_UPPER = MnPlacedFeatures.key("tenebrum_ore_upper");
    public static final ResourceKey<PlacedFeature> TENEBRUM_ORE_LOWER = MnPlacedFeatures.key("tenebrum_ore_lower");
    public static final ResourceKey<PlacedFeature> DARK_PEARL_ORE = MnPlacedFeatures.key("dark_pearl_ore");
    public static final ResourceKey<PlacedFeature> DARK_PEARL_ORE_LARGE = MnPlacedFeatures.key("dark_pearl_ore_large");
    public static final ResourceKey<PlacedFeature> RENDIUM_ORE = MnPlacedFeatures.key("rendium_ore");
    public static final ResourceKey<PlacedFeature> RENDIUM_ORE_EXTRA = MnPlacedFeatures.key("rendium_ore_extra");
    public static final ResourceKey<PlacedFeature> VIRILUX_ORE = MnPlacedFeatures.key("virilux_ore");
    public static final ResourceKey<PlacedFeature> UNDERGROUND_NIGHT_DIRT = MnPlacedFeatures.key("underground_night_dirt");
    public static final ResourceKey<PlacedFeature> STINGER_EGGS = MnPlacedFeatures.key("stinger_eggs");
    public static final ResourceKey<PlacedFeature> ROUXE_CLUSTER = MnPlacedFeatures.key("rouxe_cluster");
    public static final ResourceKey<PlacedFeature> ROUXE_CRYSTAL = MnPlacedFeatures.key("rouxe_crystal");
    public static final ResourceKey<PlacedFeature> GIANT_GLOB_FUNGUS = MnPlacedFeatures.key("giant_glob_fungus");
    public static final ResourceKey<PlacedFeature> GLOB_FUNGUS = MnPlacedFeatures.key("glob_fungus");
    public static final ResourceKey<PlacedFeature> CRYSTALOTUS = MnPlacedFeatures.key("crystalotus");
    public static final ResourceKey<PlacedFeature> MALEVOLENT_TREE = MnPlacedFeatures.key("malevolent_tree");
    public static final ResourceKey<PlacedFeature> GIANT_NIGHTSHROOMS = MnPlacedFeatures.key("giant_nightshrooms");
    public static final ResourceKey<PlacedFeature> GIANT_DEWSHROOMS = MnPlacedFeatures.key("giant_dewshrooms");
    public static final ResourceKey<PlacedFeature> GIANT_VIRIDSHROOMS = MnPlacedFeatures.key("giant_viridshrooms");
    public static final ResourceKey<PlacedFeature> GIANT_BOGSHROOMS = MnPlacedFeatures.key("giant_bogshrooms");
    public static final ResourceKey<PlacedFeature> SPARSE_SMALL_GIANT_NIGHTSHROOMS = MnPlacedFeatures.key("sparce_small_giant_nightshrooms");
    public static final ResourceKey<PlacedFeature> SPARSE_SMALL_MEDIUM_GIANT_NIGHTSHROOMS = MnPlacedFeatures.key("sparse_small_medium_giant_nightshrooms");
    public static final ResourceKey<PlacedFeature> DEAD_TREES_SPARSE = MnPlacedFeatures.key("dead_trees_sparse");
    public static final ResourceKey<PlacedFeature> DEAD_TREES_DENSE = MnPlacedFeatures.key("dead_trees_dense");
    public static final ResourceKey<PlacedFeature> DARK_WILLOW_TREES = MnPlacedFeatures.key("dark_willow_trees");
    public static final ResourceKey<PlacedFeature> DARK_WILLOW_TREES_RARE = MnPlacedFeatures.key("dark_willow_trees_rare");
    public static final ResourceKey<PlacedFeature> SHADOWROOT_TREES_DENSE = MnPlacedFeatures.key("shadowroot_trees_dense");
    public static final ResourceKey<PlacedFeature> SHADOWROOT_TREES_SPARSE = MnPlacedFeatures.key("shadowroot_trees_sparse");
    public static final ResourceKey<PlacedFeature> SHADOWROOT_TREES_TALL_DENSE = MnPlacedFeatures.key("shadowroot_trees_tall_dense");
    public static final ResourceKey<PlacedFeature> DEAD_LOG_RARE = MnPlacedFeatures.key("dead_log_rare");
    public static final ResourceKey<PlacedFeature> DEAD_LOG_COMMON = MnPlacedFeatures.key("dead_log_common");
    public static final ResourceKey<PlacedFeature> DEAD_STUMP_RARE = MnPlacedFeatures.key("dead_stump_rare");
    public static final ResourceKey<PlacedFeature> DEAD_STUMP_COMMON = MnPlacedFeatures.key("dead_stump_common");
    public static final ResourceKey<PlacedFeature> SUAVIS_COMMON = MnPlacedFeatures.key("suavis_common");
    public static final ResourceKey<PlacedFeature> SUAVIS_RARE = MnPlacedFeatures.key("suavis_rare");
    public static final ResourceKey<PlacedFeature> NIGHT_REEDS_RARE = MnPlacedFeatures.key("night_reeds_rare");
    public static final ResourceKey<PlacedFeature> NIGHT_REEDS_COMMON = MnPlacedFeatures.key("night_reeds_common");
    public static final ResourceKey<PlacedFeature> DEAD_SAPLING = MnPlacedFeatures.key("dead_sapling");
    public static final ResourceKey<PlacedFeature> SHROOM_SHELVES = MnPlacedFeatures.key("shroom_shelves");
    public static final ResourceKey<PlacedFeature> BLADESHROOMS = MnPlacedFeatures.key("bladeshrooms");
    public static final ResourceKey<PlacedFeature> TENDRILWEED = MnPlacedFeatures.key("tendrilweed");
    public static final ResourceKey<PlacedFeature> FINGERED_GRASS = MnPlacedFeatures.key("fingered_grass");
    public static final ResourceKey<PlacedFeature> MALIGNANT_PLANTS = MnPlacedFeatures.key("malignant_plants");
    public static final ResourceKey<PlacedFeature> NIGHTSHROOM_RING = MnPlacedFeatures.key("nightshroom_ring");
    public static final ResourceKey<PlacedFeature> NIGHTSHROOMS = MnPlacedFeatures.key("nightshrooms");
    public static final ResourceKey<PlacedFeature> NIGHTSHROOMS_SPARSE = MnPlacedFeatures.key("nightshrooms_sparse");
    public static final ResourceKey<PlacedFeature> DEWSHROOMS = MnPlacedFeatures.key("dewshrooms");
    public static final ResourceKey<PlacedFeature> VIRIDSHROOMS = MnPlacedFeatures.key("viridshrooms");
    public static final ResourceKey<PlacedFeature> BOGSHROOMS = MnPlacedFeatures.key("bogshrooms");
    public static final ResourceKey<PlacedFeature> MISTSHROOMS = MnPlacedFeatures.key("mistshrooms");
    public static final ResourceKey<PlacedFeature> MOONSHROOMS = MnPlacedFeatures.key("moonshrooms");
    public static final ResourceKey<PlacedFeature> LUMEN_BUDS = MnPlacedFeatures.key("lumen_buds");
    public static final ResourceKey<PlacedFeature> BOGWEED = MnPlacedFeatures.key("bogweed");
    public static final ResourceKey<PlacedFeature> GHOST_PLANTS_SPARSE = MnPlacedFeatures.key("ghost_plants_sparse");
    public static final ResourceKey<PlacedFeature> GHOST_PLANTS = MnPlacedFeatures.key("ghost_plants");
    public static final ResourceKey<PlacedFeature> VIOLEAFS = MnPlacedFeatures.key("violeafs");
    public static final ResourceKey<PlacedFeature> CRYSTAL_FLOWERS = MnPlacedFeatures.key("crystal_flowers");
    public static final ResourceKey<PlacedFeature> RUNEBUSHES = MnPlacedFeatures.key("runebushes");
    public static final ResourceKey<PlacedFeature> TALL_GRASS_PLAIN = MnPlacedFeatures.key("tall_grass_plain");
    public static final ResourceKey<PlacedFeature> TALL_GRASS_PLAIN_DENSE = MnPlacedFeatures.key("tall_grass_plain_dense");
    public static final ResourceKey<PlacedFeature> TALL_GRASS_MARSH = MnPlacedFeatures.key("tall_grass_marsh");
    public static final ResourceKey<PlacedFeature> GRASS_FOREST = MnPlacedFeatures.key("grass_forest");
    public static final ResourceKey<PlacedFeature> GRASS_PLAIN = MnPlacedFeatures.key("grass_plain");
    public static final ResourceKey<PlacedFeature> GRASS_PLAIN_DENSE = MnPlacedFeatures.key("grass_plain_dense");
    public static final ResourceKey<PlacedFeature> DECEITFUL_ALGAE = MnPlacedFeatures.key("deceitful_algae");
    public static final ResourceKey<PlacedFeature> DRAGONS_NEST = MnPlacedFeatures.key("dragons_nest");
    public static final ResourceKey<PlacedFeature> UNSTABLE_BUSH = MnPlacedFeatures.key("unstable_bush");
    public static final ResourceKey<PlacedFeature> UMBRAFLAME_PATCH = MnPlacedFeatures.key("umbraflame_patch");
    public static final ResourceKey<PlacedFeature> LARGE_GIANT_NIGHTSHROOM_CHECKED = MnPlacedFeatures.key("large_giant_nightshroom_checked");
    public static final ResourceKey<PlacedFeature> MEDIUM_GIANT_NIGHTSHROOM_CHECKED = MnPlacedFeatures.key("medium_giant_nightshroom_checked");
    public static final ResourceKey<PlacedFeature> SMALL_GIANT_NIGHTSHROOM_CHECKED = MnPlacedFeatures.key("small_giant_nightshroom_checked");
    public static final ResourceKey<PlacedFeature> LARGE_GIANT_DEWSHROOM_CHECKED = MnPlacedFeatures.key("large_giant_dewshroom_checked");
    public static final ResourceKey<PlacedFeature> MEDIUM_GIANT_DEWSHROOM_CHECKED = MnPlacedFeatures.key("medium_giant_dewshroom_checked");
    public static final ResourceKey<PlacedFeature> SMALL_GIANT_DEWSHROOM_CHECKED = MnPlacedFeatures.key("small_giant_dewshroom_checked");
    public static final ResourceKey<PlacedFeature> LARGE_GIANT_VIRIDSHROOM_CHECKED = MnPlacedFeatures.key("large_giant_viridshroom_checked");
    public static final ResourceKey<PlacedFeature> MEDIUM_GIANT_VIRIDSHROOM_CHECKED = MnPlacedFeatures.key("medium_giant_viridshroom_checked");
    public static final ResourceKey<PlacedFeature> SMALL_GIANT_VIRIDSHROOM_CHECKED = MnPlacedFeatures.key("small_giant_viridshroom_checked");
    public static final ResourceKey<PlacedFeature> LARGE_GIANT_BOGSHROOM_CHECKED = MnPlacedFeatures.key("large_giant_bogshroom_checked");
    public static final ResourceKey<PlacedFeature> SMALL_GIANT_BOGSHROOM_CHECKED = MnPlacedFeatures.key("small_giant_bogshroom_checked");
    public static final ResourceKey<PlacedFeature> SMALL_RUIN = MnPlacedFeatures.key("small_ruin");

    private static ResourceKey<PlacedFeature> key(String name) {
        return MnRegistry.PLACED_FEATURES.key(name);
    }

    private static Holder<ConfiguredFeature<?, ?>> getConfigured(BootstapContext<PlacedFeature> ctx, ResourceKey<ConfiguredFeature<?, ?>> key) {
        return ctx.m_255420_(Registries.f_256911_).m_255043_(key);
    }

    private static Holder<PlacedFeature> register(BootstapContext<PlacedFeature> ctx, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> configured, PlacementModifier ... placements) {
        return MnPlacedFeatures.register(ctx, key, MnPlacedFeatures.getConfigured(ctx, configured), List.of(placements));
    }

    private static Holder<PlacedFeature> register(BootstapContext<PlacedFeature> ctx, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> configured, List<? extends PlacementModifier> placements) {
        return MnPlacedFeatures.register(ctx, key, MnPlacedFeatures.getConfigured(ctx, configured), placements);
    }

    private static Holder<PlacedFeature> register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuredFeatures, PlacementModifier ... placements) {
        return MnPlacedFeatures.register(context, key, configuredFeatures, List.of(placements));
    }

    private static Holder<PlacedFeature> register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuredFeature, List<? extends PlacementModifier> placements) {
        return MnRegistry.PLACED_FEATURES.register(context, key, (Object)new PlacedFeature(configuredFeature, List.copyOf(placements)));
    }

    static void bootstrap(BootstapContext<PlacedFeature> ctx) {
        MnPlacedFeatures.register(ctx, PIT, MnConfiguredFeatures.PIT, MnPlacedFeatures.rareSurface(6, PlacementUtils.f_195353_));
        MnPlacedFeatures.register(ctx, TRENCHSTONE_BOULDER, MnConfiguredFeatures.TRENCHSTONE_BOULDER, MnPlacedFeatures.rareSurface(8, PlacementUtils.f_195353_));
        MnPlacedFeatures.register(ctx, NIGHTSTONE_BOULDER, MnConfiguredFeatures.NIGHTSTONE_BOULDER, MnPlacedFeatures.rareSurface(8, PlacementUtils.f_195353_));
        MnPlacedFeatures.register(ctx, NIGHTSTONE_SPIKE, MnConfiguredFeatures.NIGHTSTONE_SPIKE, MnPlacedFeatures.rareSurface(8, PlacementUtils.f_195353_));
        MnPlacedFeatures.register(ctx, BLOOMCRYSTAL_CLUSTERS, MnConfiguredFeatures.BLOOMCRYSTAL_CLUSTER, MnPlacedFeatures.commonSurface(2, PlacementUtils.f_195353_));
        MnPlacedFeatures.register(ctx, ROCKSHROOM_HEAP, MnConfiguredFeatures.ROCKSHROOM_HEAP, MnPlacedFeatures.rareSurface(10, PlacementUtils.f_195353_));
        MnPlacedFeatures.register(ctx, VIRILUX_CAVE, MnConfiguredFeatures.VIRILUX_CAVE, MnPlacedFeatures.rareWithRange(24, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-28), (VerticalAnchor)VerticalAnchor.m_158922_((int)32))));
        MnPlacedFeatures.register(ctx, WATER_DELTA, MnConfiguredFeatures.WATER_DELTA, MnPlacedFeatures.commonSurface(10, PlacementUtils.f_195353_));
        MnPlacedFeatures.register(ctx, EBONITE_ORE, MnConfiguredFeatures.EBONITE_ORE, MnPlacedFeatures.commonOre(50, HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)64), (VerticalAnchor)VerticalAnchor.m_158922_((int)256))));
        MnPlacedFeatures.register(ctx, NAGRILITE_ORE, MnConfiguredFeatures.NAGRILITE_ORE, MnPlacedFeatures.commonOre(35, HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-16), (VerticalAnchor)VerticalAnchor.m_158922_((int)56))));
        MnPlacedFeatures.register(ctx, NAGRILITE_ORE_WIDE, MnConfiguredFeatures.NAGRILITE_ORE, MnPlacedFeatures.commonOre(15, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)72))));
        MnPlacedFeatures.register(ctx, TENEBRUM_ORE_UPPER, MnConfiguredFeatures.TENEBRUM_ORE, MnPlacedFeatures.commonOre(18, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)-48), (VerticalAnchor)VerticalAnchor.m_158930_((int)48))));
        MnPlacedFeatures.register(ctx, TENEBRUM_ORE_LOWER, MnConfiguredFeatures.TENEBRUM_ORE_BURIED, MnPlacedFeatures.commonOre(5, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)20))));
        MnPlacedFeatures.register(ctx, DARK_PEARL_ORE, MnConfiguredFeatures.DARK_PEARL_ORE_SMALL, MnPlacedFeatures.commonOre(100, HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)108))));
        MnPlacedFeatures.register(ctx, DARK_PEARL_ORE_LARGE, MnConfiguredFeatures.DARK_PEARL_ORE_LARGE, MnPlacedFeatures.commonOre(100, HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)108))));
        MnPlacedFeatures.register(ctx, RENDIUM_ORE, MnConfiguredFeatures.RENDIUM_ORE, MnPlacedFeatures.commonOre(15, HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)116))));
        MnPlacedFeatures.register(ctx, RENDIUM_ORE_EXTRA, MnConfiguredFeatures.RENDIUM_ORE, MnPlacedFeatures.commonOre(30, HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)116))));
        MnPlacedFeatures.register(ctx, VIRILUX_ORE, MnConfiguredFeatures.VIRILUX_ORE, MnPlacedFeatures.commonOre(15, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-32), (VerticalAnchor)VerticalAnchor.m_158922_((int)36))));
        MnPlacedFeatures.register(ctx, UNDERGROUND_NIGHT_DIRT, MnConfiguredFeatures.UNDERGROUND_NIGHT_DIRT, MnPlacedFeatures.commonOre(7, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)160))));
        MnPlacedFeatures.register(ctx, STINGER_EGGS, MnConfiguredFeatures.STINGER_EGGS, MnPlacedFeatures.commonUnderground(30, 12));
        MnPlacedFeatures.register(ctx, ROUXE_CLUSTER, MnConfiguredFeatures.ROUXE_CLUSTER, MnPlacedFeatures.commonUnderground(17, 12, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)48))));
        MnPlacedFeatures.register(ctx, ROUXE_CRYSTAL, MnConfiguredFeatures.ROUXE_CRYSTALS, MnPlacedFeatures.commonUnderground(6, 7, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)72))));
        MnPlacedFeatures.register(ctx, GIANT_GLOB_FUNGUS, MnConfiguredFeatures.GIANT_GLOB_FUNGUS, new PlacementModifier[]{CountPlacement.m_191628_((int)40), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)64)), EnvironmentScanPlacement.m_191657_((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.m_190432_(), (BlockPredicate)BlockPredicate.f_190393_, (int)10), RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)1)), PlacementUtils.m_206493_((Block)((Block)MnBlocks.GLOB_FUNGUS.get())), BiomeFilter.m_191561_()});
        MnPlacedFeatures.register(ctx, GLOB_FUNGUS, MnConfiguredFeatures.GLOB_FUNGUS, MnPlacedFeatures.commonUnderground(100, 12));
        MnPlacedFeatures.register(ctx, CRYSTALOTUS, MnConfiguredFeatures.CRYSTALOTUS, MnPlacedFeatures.commonUnderground(40));
        MnPlacedFeatures.register(ctx, UMBRAFLAME_PATCH, MnConfiguredFeatures.UMBRAFLAME_PATCH, MnPlacedFeatures.commonUnderground(20, 4, HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)-112), (VerticalAnchor)VerticalAnchor.m_158930_((int)112))));
        MnPlacedFeatures.register(ctx, MALEVOLENT_TREE, MnConfiguredFeatures.MALEVOLENT_TREE, MnPlacedFeatures.surfaceTreeCount(4, 0));
        MnPlacedFeatures.register(ctx, GIANT_NIGHTSHROOMS, MnConfiguredFeatures.GIANT_NIGHTSHROOMS, MnPlacedFeatures.surfaceTreeCount(3, 0));
        MnPlacedFeatures.register(ctx, GIANT_DEWSHROOMS, MnConfiguredFeatures.GIANT_DEWSHROOMS, MnPlacedFeatures.surfaceTreeCount(3, 0));
        MnPlacedFeatures.register(ctx, GIANT_VIRIDSHROOMS, MnConfiguredFeatures.GIANT_VIRIDSHROOMS, MnPlacedFeatures.surfaceTreeCount(3, 0));
        MnPlacedFeatures.register(ctx, GIANT_BOGSHROOMS, MnConfiguredFeatures.GIANT_BOGSHROOMS, MnPlacedFeatures.surfaceTreeChance(3, 1));
        MnPlacedFeatures.register(ctx, SPARSE_SMALL_GIANT_NIGHTSHROOMS, MnConfiguredFeatures.GIANT_NIGHTSHROOM_SMALL, MnPlacedFeatures.surfaceTreeChance(7, 0));
        MnPlacedFeatures.register(ctx, SPARSE_SMALL_MEDIUM_GIANT_NIGHTSHROOMS, MnConfiguredFeatures.GIANT_NIGHTSHROOMS_NO_LARGE, MnPlacedFeatures.surfaceTreeChance(7, 0));
        MnPlacedFeatures.register(ctx, DEAD_TREES_SPARSE, MnConfiguredFeatures.DEAD_TREE, MnPlacedFeatures.surfaceTreeChance(12, 2));
        MnPlacedFeatures.register(ctx, DEAD_TREES_DENSE, MnConfiguredFeatures.DEAD_TREE, MnPlacedFeatures.surfaceTreeCount(3, 2));
        MnPlacedFeatures.register(ctx, DARK_WILLOW_TREES, MnConfiguredFeatures.DARK_WILLOW_TREE, MnPlacedFeatures.surfaceTreeCount(3, 2));
        MnPlacedFeatures.register(ctx, DARK_WILLOW_TREES_RARE, MnConfiguredFeatures.DARK_WILLOW_TREE, MnPlacedFeatures.surfaceTreeChance(2, 1));
        MnPlacedFeatures.register(ctx, SHADOWROOT_TREES_DENSE, MnConfiguredFeatures.SHADOWROOT_TREE_SHORT, MnPlacedFeatures.surfaceTreeCountExtra(7, 0.2f, 1, 0));
        MnPlacedFeatures.register(ctx, SHADOWROOT_TREES_SPARSE, MnConfiguredFeatures.SHADOWROOT_TREE_SHORT, MnPlacedFeatures.surfaceTreeChance(6, 0));
        MnPlacedFeatures.register(ctx, SHADOWROOT_TREES_TALL_DENSE, MnConfiguredFeatures.SHADOWROOT_TREE_TALL, MnPlacedFeatures.surfaceTreeCountExtra(7, 0.2f, 1, 0));
        MnPlacedFeatures.register(ctx, DEAD_LOG_RARE, MnConfiguredFeatures.DEAD_LOG, MnPlacedFeatures.surfaceTreeChance(7, 6));
        MnPlacedFeatures.register(ctx, DEAD_LOG_COMMON, MnConfiguredFeatures.DEAD_LOG, MnPlacedFeatures.surfaceTreeChance(3, 6));
        MnPlacedFeatures.register(ctx, DEAD_STUMP_RARE, MnConfiguredFeatures.DEAD_STUMP, MnPlacedFeatures.rareSurfaceChecked(3, PlacementUtils.f_195353_, MnBlocks.DEAD_SAPLING));
        MnPlacedFeatures.register(ctx, DEAD_STUMP_COMMON, MnConfiguredFeatures.DEAD_STUMP, MnPlacedFeatures.commonSurfaceChecked(2, PlacementUtils.f_195353_, MnBlocks.DEAD_SAPLING));
        MnPlacedFeatures.register(ctx, SUAVIS_COMMON, MnConfiguredFeatures.SUAVIS_LARGE, MnPlacedFeatures.rareSurface(2, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, SUAVIS_RARE, MnConfiguredFeatures.SUAVIS_SMALL, MnPlacedFeatures.rareSurface(8, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, NIGHT_REEDS_RARE, MnConfiguredFeatures.NIGHT_REEDS, MnPlacedFeatures.rareSurface(6, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, NIGHT_REEDS_COMMON, MnConfiguredFeatures.NIGHT_REEDS, MnPlacedFeatures.commonSurface(1, PlacementUtils.f_195353_));
        MnPlacedFeatures.register(ctx, DEAD_SAPLING, MnConfiguredFeatures.DEAD_SAPLING, MnPlacedFeatures.commonSurface(3, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, SHROOM_SHELVES, MnConfiguredFeatures.SHROOM_SHELVES, MnPlacedFeatures.commonSurfaceWithRandomOffset(16, PlacementUtils.f_195354_, 16));
        MnPlacedFeatures.register(ctx, BLADESHROOMS, MnConfiguredFeatures.BLADESHROOM, MnPlacedFeatures.rareSurface(3, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, TENDRILWEED, MnConfiguredFeatures.TENDRILWEED, MnPlacedFeatures.rareSurface(5, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, FINGERED_GRASS, MnConfiguredFeatures.FINGERED_GRASS, MnPlacedFeatures.rareSurface(5, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, MALIGNANT_PLANTS, MnConfiguredFeatures.MALIGNANT_PLANTS, MnPlacedFeatures.commonSurface(5, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, NIGHTSHROOM_RING, MnConfiguredFeatures.NIGHTSHROOM_RING, MnPlacedFeatures.commonSurfaceExtra(1, 0.5f, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, NIGHTSHROOMS, MnConfiguredFeatures.NIGHTSHROOMS, MnPlacedFeatures.surfaceBiomeRange(40));
        MnPlacedFeatures.register(ctx, NIGHTSHROOMS_SPARSE, MnConfiguredFeatures.NIGHTSHROOMS, MnPlacedFeatures.surfaceBiomeRange(25));
        MnPlacedFeatures.register(ctx, DEWSHROOMS, MnConfiguredFeatures.DEWSHROOMS, MnPlacedFeatures.surfaceBiomeRange(40));
        MnPlacedFeatures.register(ctx, VIRIDSHROOMS, MnConfiguredFeatures.VIRIDSHROOMS, MnPlacedFeatures.surfaceBiomeRange(40));
        MnPlacedFeatures.register(ctx, BOGSHROOMS, MnConfiguredFeatures.BOGSHROOMS, MnPlacedFeatures.rareSurface(2, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, MISTSHROOMS, MnConfiguredFeatures.MISTSHROOMS, MnPlacedFeatures.commonSurface(1, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, MOONSHROOMS, MnConfiguredFeatures.MOONSHROOMS, MnPlacedFeatures.rareSurface(2, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, LUMEN_BUDS, MnConfiguredFeatures.LUMEN_BUDS, MnPlacedFeatures.rareSurface(4, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, BOGWEED, MnConfiguredFeatures.BOGWEED, MnPlacedFeatures.rareSurface(2, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, GHOST_PLANTS_SPARSE, MnConfiguredFeatures.GHOST_PLANT, MnPlacedFeatures.rareSurface(3, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, GHOST_PLANTS, MnConfiguredFeatures.GHOST_PLANT, MnPlacedFeatures.commonSurface(1, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, VIOLEAFS, MnConfiguredFeatures.VIOLEAF, MnPlacedFeatures.commonSurface(2, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, CRYSTAL_FLOWERS, MnConfiguredFeatures.CRYSTAL_FLOWER, MnPlacedFeatures.commonSurface(2, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, RUNEBUSHES, MnConfiguredFeatures.RUNEBUSH, MnPlacedFeatures.commonSurface(32, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, TALL_GRASS_PLAIN, MnConfiguredFeatures.TALL_GRASS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)0, (int)7), RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        MnPlacedFeatures.register(ctx, TALL_GRASS_PLAIN_DENSE, MnConfiguredFeatures.TALL_GRASS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)3, (int)9), RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        MnPlacedFeatures.register(ctx, TALL_GRASS_MARSH, MnConfiguredFeatures.TALL_GRASS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)4, (int)9), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        MnPlacedFeatures.register(ctx, GRASS_FOREST, MnConfiguredFeatures.GRASS, MnPlacedFeatures.commonSurface(6, PlacementUtils.f_195354_));
        MnPlacedFeatures.register(ctx, GRASS_PLAIN, MnConfiguredFeatures.GRASS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        MnPlacedFeatures.register(ctx, GRASS_PLAIN_DENSE, MnConfiguredFeatures.GRASS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)10, (int)15), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        MnPlacedFeatures.register(ctx, DECEITFUL_ALGAE, MnConfiguredFeatures.DECEITFUL_ALGAE, MnPlacedFeatures.commonSurface(4, PlacementUtils.f_195354_));
        MnPlacedFeatures.register(ctx, DRAGONS_NEST, MnConfiguredFeatures.DRAGONS_NEST, MnPlacedFeatures.commonSurfaceUpwardScanning(5, PlacementUtils.f_195354_));
        MnPlacedFeatures.register(ctx, UNSTABLE_BUSH, MnConfiguredFeatures.UNSTABLE_BUSH, MnPlacedFeatures.rareSurface(2, PlacementUtils.f_195352_));
        MnPlacedFeatures.register(ctx, MALIGNANT_PATCH_COMMON, MnConfiguredFeatures.MALIGNANT_PATCH, MnPlacedFeatures.rareSurface(2, PlacementUtils.f_195353_));
        MnPlacedFeatures.register(ctx, MALIGNANT_PATCH_UNCOMMON, MnConfiguredFeatures.MALIGNANT_PATCH, MnPlacedFeatures.rareSurface(3, PlacementUtils.f_195353_));
        MnPlacedFeatures.register(ctx, MALIGNANT_PATCH_RARE, MnConfiguredFeatures.MALIGNANT_PATCH, MnPlacedFeatures.rareSurface(4, PlacementUtils.f_195353_));
        MnPlacedFeatures.register(ctx, LARGE_GIANT_NIGHTSHROOM_CHECKED, MnConfiguredFeatures.GIANT_NIGHTSHROOM_LARGE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)MnBlocks.NIGHTSHROOM.get()))});
        MnPlacedFeatures.register(ctx, MEDIUM_GIANT_NIGHTSHROOM_CHECKED, MnConfiguredFeatures.GIANT_NIGHTSHROOM_MEDIUM, new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)MnBlocks.NIGHTSHROOM.get()))});
        MnPlacedFeatures.register(ctx, SMALL_GIANT_NIGHTSHROOM_CHECKED, MnConfiguredFeatures.GIANT_NIGHTSHROOM_SMALL, new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)MnBlocks.NIGHTSHROOM.get()))});
        MnPlacedFeatures.register(ctx, LARGE_GIANT_DEWSHROOM_CHECKED, MnConfiguredFeatures.GIANT_DEWSHROOM_LARGE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)MnBlocks.DEWSHROOM.get()))});
        MnPlacedFeatures.register(ctx, MEDIUM_GIANT_DEWSHROOM_CHECKED, MnConfiguredFeatures.GIANT_DEWSHROOM_MEDIUM, new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)MnBlocks.DEWSHROOM.get()))});
        MnPlacedFeatures.register(ctx, SMALL_GIANT_DEWSHROOM_CHECKED, MnConfiguredFeatures.GIANT_DEWSHROOM_SMALL, new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)MnBlocks.DEWSHROOM.get()))});
        MnPlacedFeatures.register(ctx, LARGE_GIANT_VIRIDSHROOM_CHECKED, MnConfiguredFeatures.GIANT_VIRIDSHROOM_LARGE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)MnBlocks.VIRIDSHROOM.get()))});
        MnPlacedFeatures.register(ctx, MEDIUM_GIANT_VIRIDSHROOM_CHECKED, MnConfiguredFeatures.GIANT_VIRIDSHROOM_MEDIUM, new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)MnBlocks.VIRIDSHROOM.get()))});
        MnPlacedFeatures.register(ctx, SMALL_GIANT_VIRIDSHROOM_CHECKED, MnConfiguredFeatures.GIANT_VIRIDSHROOM_SMALL, new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)MnBlocks.VIRIDSHROOM.get()))});
        MnPlacedFeatures.register(ctx, LARGE_GIANT_BOGSHROOM_CHECKED, MnConfiguredFeatures.GIANT_BOGSHROOM_LARGE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)MnBlocks.BOGSHROOM.get()))});
        MnPlacedFeatures.register(ctx, SMALL_GIANT_BOGSHROOM_CHECKED, MnConfiguredFeatures.GIANT_BOGSHROOM_SMALL, new PlacementModifier[]{PlacementUtils.m_206493_((Block)((Block)MnBlocks.BOGSHROOM.get()))});
        MnPlacedFeatures.register(ctx, SMALL_RUIN, MnConfiguredFeatures.SMALL_RUIN, MnPlacedFeatures.rareSurfaceWithOffset(4, PlacementUtils.f_195354_));
    }

    private static List<? extends PlacementModifier> commonSurfaceChecked(int count, PlacementModifier heightmapPlacement, Supplier<? extends Block> blockToCheckSurvival) {
        return List.of(CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), heightmapPlacement, PlacementUtils.m_206493_((Block)blockToCheckSurvival.get()), BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> commonSurface(int count, PlacementModifier heightmapPlacement) {
        return List.of(CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), heightmapPlacement, BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> commonSurfaceExtra(int count, float chanceOfExtra, PlacementModifier heightmapPlacement) {
        return List.of(PlacementUtils.m_195364_((int)count, (float)chanceOfExtra, (int)1), InSquarePlacement.m_191715_(), heightmapPlacement, BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> commonSurfaceUpwardScanning(int count, PlacementModifier heightmapPlacement) {
        return List.of(CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), heightmapPlacement, EnvironmentScanPlacement.m_191657_((Direction)Direction.UP, (BlockPredicate)BlockPredicate.m_190432_(), (BlockPredicate)BlockPredicate.f_190393_, (int)12), BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> commonSurfaceWithRandomOffset(int count, PlacementModifier heightmapPlacement, int maxVerticalDistance) {
        return List.of(CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), heightmapPlacement, RandomOffsetPlacement.m_191877_((IntProvider)UniformInt.m_146622_((int)1, (int)maxVerticalDistance)), BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> rareSurface(int chance, PlacementModifier heightmapPlacement) {
        return List.of(RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), heightmapPlacement, BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> rareSurfaceWithOffset(int chance, PlacementModifier heightmapPlacement) {
        return List.of(RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), heightmapPlacement, RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)-1)), BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> rareSurfaceChecked(int chance, PlacementModifier heightmapPlacement, Supplier<? extends Block> blockToCheckSurvival) {
        return List.of(RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), heightmapPlacement, PlacementUtils.m_206493_((Block)blockToCheckSurvival.get()), BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> surfaceTreeChance(int chance, int maxWaterDepth) {
        return List.of(RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)maxWaterDepth), PlacementUtils.f_195353_, BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> surfaceTreeCount(int count, int maxWaterDepth) {
        return List.of(CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)maxWaterDepth), PlacementUtils.f_195353_, BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> surfaceTreeCountExtra(int count, float chanceOfExtra, int extra, int maxDepth) {
        return List.of(PlacementUtils.m_195364_((int)count, (float)chanceOfExtra, (int)extra), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)maxDepth), PlacementUtils.f_195353_, BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> commonUnderground(int count, int scanningRange, HeightRangePlacement heightRange) {
        return List.of(CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), heightRange, EnvironmentScanPlacement.m_191657_((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.m_190432_(), (BlockPredicate)BlockPredicate.f_190393_, (int)scanningRange), RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)1)), BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> commonUnderground(int count, int scanningRange) {
        return MnPlacedFeatures.commonUnderground(count, scanningRange, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)255)));
    }

    private static List<? extends PlacementModifier> commonUnderground(int count, HeightRangePlacement heightRange) {
        return List.of(CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), heightRange, BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> commonUnderground(int count) {
        return MnPlacedFeatures.commonUnderground(count, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)255)));
    }

    private static List<? extends PlacementModifier> rareWithRange(int chance, HeightRangePlacement heightRange) {
        return List.of(RarityFilter.m_191900_((int)chance), InSquarePlacement.m_191715_(), heightRange, BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> commonOre(int count, HeightRangePlacement placementModifier) {
        return MnPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), placementModifier);
    }

    private static List<? extends PlacementModifier> rareOre(int count, HeightRangePlacement placementModifier) {
        return MnPlacedFeatures.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)count), placementModifier);
    }

    private static List<? extends PlacementModifier> orePlacement(PlacementModifier frequencyPlacement, HeightRangePlacement heightRangePlacement) {
        return List.of(frequencyPlacement, InSquarePlacement.m_191715_(), heightRangePlacement, BiomeFilter.m_191561_());
    }

    private static List<? extends PlacementModifier> surfaceBiomeRange(int count) {
        return List.of(CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191683_((HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)48), (VerticalAnchor)VerticalAnchor.m_158922_((int)256))), BiomeFilter.m_191561_());
    }

    private static HeightRangePlacement trapezoidHeightRange(VerticalAnchor bottom, VerticalAnchor top, int plateau) {
        return HeightRangePlacement.m_191683_((HeightProvider)TrapezoidHeight.m_162009_((VerticalAnchor)bottom, (VerticalAnchor)top, (int)plateau));
    }
}

