/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.network.level;

import com.crypticmushroom.minecraft.midnight.client.MidnightClient;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.RiftAttachment;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.RiftBridge;
import com.crypticmushroom.minecraft.midnight.common.network.MnPacket;
import com.crypticmushroom.minecraft.midnight.common.world.manager.RiftBridgeManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class RiftBridgeMessage
implements MnPacket {
    protected final int bridgeId;

    protected RiftBridgeMessage(RiftBridge bridge) {
        this(bridge.getId());
    }

    protected RiftBridgeMessage(int bridgeId) {
        this.bridgeId = bridgeId;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.bridgeId);
    }

    public static class Remove
    extends RiftBridgeMessage {
        public Remove(RiftBridge bridge) {
            super(bridge);
        }

        private Remove(int bridgeId) {
            super(bridgeId);
        }

        @Override
        public void handle(NetworkEvent.Context context) {
            context.enqueueWork(() -> MidnightClient.get().getBridgeManager().remove(this.bridgeId));
            super.handle(context);
        }

        public static Remove read(FriendlyByteBuf buffer) {
            return new Remove(buffer.readInt());
        }
    }

    public static class Create
    extends RiftBridgeMessage {
        private final RiftAttachment attachment;
        private final FriendlyByteBuf data;

        public Create(RiftBridge bridge) {
            super(bridge);
            this.attachment = bridge.getAttachment();
            this.data = new FriendlyByteBuf(Unpooled.buffer());
            bridge.writeState(this.data);
        }

        private Create(int bridgeId, RiftAttachment attachment, FriendlyByteBuf data) {
            super(bridgeId);
            this.attachment = attachment;
            this.data = data;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            super.write(buffer);
            this.attachment.write(buffer);
            buffer.writeBytes((ByteBuf)this.data);
        }

        @Override
        public void handle(NetworkEvent.Context context) {
            context.enqueueWork(() -> {
                final RiftBridgeManager.Client manager = MidnightClient.get().getBridgeManager();
                RiftBridge bridge = Objects.requireNonNullElseGet(manager.get(this.bridgeId), () -> new RiftBridge(this.bridgeId, this.attachment){
                    {
                        super(id, attachment);
                        manager.add(this);
                    }
                });
                bridge.setAttachment(this.attachment);
                bridge.handleState(this.data);
            });
            super.handle(context);
        }

        public static Create read(FriendlyByteBuf buffer) {
            return new Create(buffer.readInt(), RiftAttachment.read(buffer), buffer);
        }
    }

    public static class State
    extends RiftBridgeMessage {
        private final FriendlyByteBuf data;

        public State(RiftBridge bridge) {
            super(bridge.getId());
            this.data = new FriendlyByteBuf(Unpooled.buffer());
            bridge.writeState(this.data);
        }

        private State(int bridgeId, FriendlyByteBuf data) {
            super(bridgeId);
            this.data = data;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            super.write(buffer);
            buffer.writeBytes((ByteBuf)this.data);
        }

        @Override
        public void handle(NetworkEvent.Context context) {
            context.enqueueWork(() -> {
                RiftBridgeManager.Client manager = MidnightClient.get().getBridgeManager();
                RiftBridge bridge = manager.get(this.bridgeId);
                if (bridge != null) {
                    bridge.handleState(this.data);
                }
            });
            super.handle(context);
        }

        public static State read(FriendlyByteBuf buffer) {
            return new State(buffer.readInt(), buffer);
        }
    }
}

