/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.network.effects;

import com.crypticmushroom.minecraft.midnight.common.network.MnPacket;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MnLocalAmbienceSoundPacket
implements MnPacket {
    private final SoundEvent soundEvent;
    private final float pitch;
    private final float volume;

    public MnLocalAmbienceSoundPacket(SoundEvent soundEvent, float pitch, float volume) {
        this.soundEvent = soundEvent;
        this.pitch = pitch;
        this.volume = volume;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.SOUND_EVENTS.getKey((Object)this.soundEvent), () -> "Attempted to get sound event ID for unregistered sound event: " + this.soundEvent.m_11660_()));
        buffer.writeFloat(this.pitch);
        buffer.writeFloat(this.volume);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119766_((SoundEvent)this.soundEvent, (float)this.pitch, (float)this.volume)));
        MnPacket.super.handle(context);
    }

    public static MnLocalAmbienceSoundPacket read(FriendlyByteBuf buffer) {
        return new MnLocalAmbienceSoundPacket((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buffer.m_130281_()), buffer.readFloat(), buffer.readFloat());
    }
}

