/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.network.effects;

import com.crypticmushroom.minecraft.midnight.client.MidnightClient;
import com.crypticmushroom.minecraft.midnight.common.network.MnPacket;
import com.crypticmushroom.minecraft.midnight.common.world.biome.effects.MidnightBiomeModifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class MnBiomeEffectsPacket
implements MnPacket {
    private final Map<ResourceLocation, MidnightBiomeModifier> modifiers;

    public MnBiomeEffectsPacket(Map<ResourceLocation, MidnightBiomeModifier> modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.modifiers.size());
        this.modifiers.forEach((biome, modifier) -> {
            buffer.m_130085_(biome);
            buffer.writeInt(modifier.getNightGrassColor());
            buffer.writeInt(modifier.getShadowrootLeavesColor());
            buffer.writeFloat(modifier.getFogDistance());
        });
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            MidnightClient.get().getBiomeModifierManager().reset();
            this.modifiers.forEach((biome, modifier) -> MidnightClient.get().getBiomeModifierManager().add((ResourceLocation)biome, (MidnightBiomeModifier)modifier));
        });
        MnPacket.super.handle(context);
    }

    public static MnBiomeEffectsPacket read(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, MidnightBiomeModifier> modifiers = new HashMap<ResourceLocation, MidnightBiomeModifier>(size);
        for (int i = 0; i < size; ++i) {
            modifiers.put(buffer.m_130281_(), new MidnightBiomeModifier(buffer.readInt(), buffer.readInt(), buffer.readFloat()));
        }
        return new MnBiomeEffectsPacket(modifiers);
    }
}

