/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.misc;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.registry.MnItems;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class MnArmorMaterials {
    public static final UUID[] SLOT_MODIFIER_UUIDS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private static final int[] DURABILITY_MULTIPLIERS = new int[]{13, 15, 16, 11};
    public static final Supplier<ArmorMaterial> ROCKSHROOM = () -> new Builder().withName(Midnight.idStr("rockshroom")).withDurabilityFactor(15).withDamageReductionAmounts(new int[]{2, 3, 4, 1}).withEnchantability(5).withToughness(1.0f).withRepairIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.ROCKSHROOM_CLUMP.get()})).build();
    public static final Supplier<ArmorMaterial> TENEBRUM = () -> new Builder().withName(Midnight.idStr("tenebrum")).withDurabilityFactor(35).withDamageReductionAmounts(new int[]{3, 6, 8, 3}).withEnchantability(9).withSound(SoundEvents.f_11679_).withToughness(3.0f).withRepairIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.TENEBRUM_INGOT.get()})).withKnockbackResistance(0.2f).build();

    private static class Builder {
        private String name;
        private int durabilityFactor;
        private int[] damageReductionAmounts;
        private int enchantability;
        private SoundEvent sound = SoundEvents.f_11675_;
        private Ingredient repairIngredient = Ingredient.f_43901_;
        private float toughness = 0.0f;
        private float knockbackResistance = 0.0f;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDurabilityFactor(int durabilityFactor) {
            this.durabilityFactor = durabilityFactor;
            return this;
        }

        public Builder withDamageReductionAmounts(int[] damageReductionAmount) {
            this.damageReductionAmounts = damageReductionAmount;
            return this;
        }

        public Builder withEnchantability(int enchantability) {
            this.enchantability = enchantability;
            return this;
        }

        public Builder withSound(SoundEvent sound) {
            this.sound = sound;
            return this;
        }

        public Builder withRepairIngredient(Ingredient repairIngredient) {
            this.repairIngredient = repairIngredient;
            return this;
        }

        public Builder withToughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        public Builder withKnockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        public ArmorMaterial build() {
            return new ArmorMaterial(){

                public int m_266425_(ArmorItem.Type type) {
                    return DURABILITY_MULTIPLIERS[type.m_266308_().m_20749_()] * durabilityFactor;
                }

                public int m_7366_(ArmorItem.Type type) {
                    return damageReductionAmounts[type.m_266308_().m_20749_()];
                }

                public int m_6646_() {
                    return enchantability;
                }

                public SoundEvent m_7344_() {
                    return sound;
                }

                public Ingredient m_6230_() {
                    return repairIngredient;
                }

                public String m_6082_() {
                    return name;
                }

                public float m_6651_() {
                    return toughness;
                }

                public float m_6649_() {
                    return knockbackResistance;
                }
            };
        }
    }
}

