/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.sensor;

import com.crypticmushroom.minecraft.midnight.common.registry.MnMemoryTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSensors;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PlayerLookedAtBySensor<E extends LivingEntity>
extends PredicateSensor<Player, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{(MemoryModuleType)MnMemoryTypes.PLAYER_LOOKED_AT_BY.get(), MemoryModuleType.f_26367_});

    public PlayerLookedAtBySensor() {
        this.setPredicate((player, entity) -> !player.m_5833_() && player.m_6084_() && !player.m_7500_());
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return MnSensors.PLAYER_LOOKED_AT_BY.get();
    }

    protected void m_5578_(ServerLevel level, E entity) {
        BrainUtils.withMemory(entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.PLAYER_LOOKED_AT_BY.get()), player -> {
            if (!this.predicate().test(player, entity) || !PlayerLookedAtBySensor.isPlayerLookingAtThis(entity, player)) {
                BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.PLAYER_LOOKED_AT_BY.get()));
            }
        });
        List nearbyPlayers = (List)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26367_);
        if (nearbyPlayers == null || nearbyPlayers.isEmpty()) {
            return;
        }
        Player nearestPlayer = nearbyPlayers.stream().filter(player -> this.predicate().test(player, entity) && PlayerLookedAtBySensor.isPlayerLookingAtThis(entity, player)).min(Comparator.comparing(pl -> pl.m_20280_((Entity)entity))).orElse(null);
        if (nearestPlayer != null) {
            BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.PLAYER_LOOKED_AT_BY.get()), (Object)nearestPlayer);
        }
    }

    public static boolean isPlayerLookingAtThis(LivingEntity entity, Player player) {
        Vec3 viewVec = player.m_20252_(1.0f).m_82541_();
        Vec3 distVec = new Vec3(entity.m_20185_() - player.m_20185_(), entity.m_20188_() - player.m_20188_(), entity.m_20189_() - player.m_20189_());
        double dist = distVec.m_82553_();
        double vecDotProduct = viewVec.m_82526_(distVec = distVec.m_82541_());
        return vecDotProduct > 1.0 - 0.025 / dist ? player.m_142582_((Entity)entity) : false;
    }
}

