/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.sensor;

import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.registry.MnMemoryTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSensors;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class NearbyRiftsSensor<E extends LivingEntity>
extends PredicateSensor<Rift, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{(MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get()});
    @Nullable
    protected SquareRadius radius = null;

    public NearbyRiftsSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyRiftsSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return MnSensors.NEARBY_RIFT.get();
    }

    protected void m_5578_(ServerLevel level, E entity) {
        SquareRadius radius = this.radius;
        if (radius == null) {
            double dist = entity.m_21133_(Attributes.f_22277_);
            radius = new SquareRadius(dist, dist);
        }
        List entities = EntityRetrievalUtil.getEntities((Level)level, (AABB)entity.m_20191_().m_82377_(radius.xzRadius(), radius.yRadius(), radius.xzRadius()), obj -> {
            if (!(obj instanceof Rift)) return false;
            Rift rift = (Rift)obj;
            if (!this.predicate().test(rift, entity)) return false;
            return true;
        });
        entities.sort(Comparator.comparingDouble(arg_0 -> entity.m_20280_(arg_0)));
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get()), (Object)entities);
    }
}

