/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.misc;

import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class SignallingItemEntity
extends Entity
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(SignallingItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected double tx;
    protected double ty;
    protected double tz;
    private boolean itemSurviveAfterDiscard;
    private int life;

    public SignallingItemEntity(EntityType<? extends SignallingItemEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SignallingItemEntity(EntityType<? extends SignallingItemEntity> entityType, Level level, double x, double y, double z) {
        this(entityType, level);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    protected abstract Item getDefaultItem();

    protected abstract int getLifeTime();

    public void setItem(ItemStack stack) {
        if (!stack.m_150930_(this.getDefaultItem()) || stack.m_41782_()) {
            this.m_20088_().m_135381_(ITEM_STACK, (Object)((ItemStack)Util.m_137469_((Object)stack.m_41777_(), copy -> copy.m_41764_(1))));
        }
    }

    private ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM_STACK);
    }

    public ItemStack m_7846_() {
        ItemStack stack = this.getItemRaw();
        return stack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : stack;
    }

    public void m_7380_(CompoundTag compound) {
        ItemStack stack = this.getItemRaw();
        if (!stack.m_41619_()) {
            compound.m_128365_("Item", (Tag)stack.m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag compound) {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Item"));
        this.setItem(stack);
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void signalTo(BlockPos targetPos) {
        this.tx = targetPos.m_123341_();
        this.ty = targetPos.m_123342_();
        this.tz = targetPos.m_123343_();
        this.itemSurviveAfterDiscard = this.shouldItemSurvive();
        this.life = 0;
    }

    public void m_6001_(double x, double y, double z) {
        this.m_20334_(x, y, z);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double dist = Math.sqrt(x * x + z * z);
            this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)y, (double)dist) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    protected abstract Vec3 getMovement(double var1, double var3, double var5);

    protected boolean shouldDiscard(float dist) {
        return false;
    }

    protected void onDiscard() {
    }

    protected boolean shouldItemSurvive() {
        return true;
    }

    protected void onItemDeath(ServerLevel serverLevel) {
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 movement = this.m_20184_();
        double vecX = this.m_20185_() + movement.f_82479_;
        double vecY = this.m_20186_() + movement.f_82480_;
        double vecZ = this.m_20189_() + movement.f_82481_;
        this.m_146926_(SignallingItemEntity.lerpRotation(this.f_19860_, (float)(Mth.m_14136_((double)movement.f_82480_, (double)movement.m_165924_()) * 57.2957763671875)));
        this.m_146922_(SignallingItemEntity.lerpRotation(this.f_19859_, (float)(Mth.m_14136_((double)movement.f_82479_, (double)movement.f_82481_) * 57.2957763671875)));
        if (!this.m_9236_().f_46443_) {
            this.m_20256_(this.getMovement(vecX, vecY, vecZ));
        }
        this.spawnParticles(movement, vecX, vecY, vecZ);
        if (this.m_9236_().f_46443_) {
            this.m_20343_(vecX, vecY, vecZ);
        } else {
            this.m_6034_(vecX, vecY, vecZ);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_6034_(vecX, vecY, vecZ);
            ++this.life;
            double dX = this.tx - vecX;
            double dZ = this.tz - vecZ;
            float dist = (float)Math.sqrt(dX * dX + dZ * dZ);
            if (this.life > this.getLifeTime() && !this.m_9236_().f_46443_ || this.shouldDiscard(dist)) {
                this.m_146870_();
                this.onDiscard();
                if (this.itemSurviveAfterDiscard) {
                    this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7846_()));
                } else {
                    this.onItemDeath((ServerLevel)this.m_9236_());
                }
            }
        } else {
            this.m_20343_(vecX, vecY, vecZ);
        }
    }

    protected void spawnParticles(Vec3 vec3, double x, double y, double z) {
    }

    public float m_213856_() {
        return 1.0f;
    }

    public boolean m_6097_() {
        return false;
    }

    protected static float lerpRotation(float currentRotation, float targetRotation) {
        while (targetRotation - currentRotation < -180.0f) {
            currentRotation -= 360.0f;
        }
        while (targetRotation - currentRotation >= 180.0f) {
            currentRotation += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)currentRotation, (float)targetRotation);
    }
}

