/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.monster;

import com.crypticmushroom.minecraft.midnight.common.entity.animation.AnimationHelper;
import com.crypticmushroom.minecraft.midnight.common.entity.network.MnEntityDataAccessor;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.INativeRiftTraveler;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.registry.MnAttributes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LegacyRifter
extends Monster
implements GeoEntity,
INativeRiftTraveler {
    public static final float HOME_SCALE_MODIFIER = 1.4f;
    public static final float DROP_DAMAGE_THRESHOLD = 2.0f;
    private static final UUID SPEED_MODIFIER_ID = UUID.fromString("3b8cda1f-c11d-478b-98b1-6144940c7ba1");
    private static final AttributeModifier HOME_SPEED_MODIFIER = new AttributeModifier(SPEED_MODIFIER_ID, "home_speed_modifier", 0.15, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final UUID ARMOR_MODIFIER_ID = UUID.fromString("8cea53c5-1b5c-4b7c-9c86-192bf255c3d4");
    private static final AttributeModifier HOME_ARMOR_MODIFIER = new AttributeModifier(ARMOR_MODIFIER_ID, "home_armor_modifier", 6.0, AttributeModifier.Operation.ADDITION);
    private static final UUID ATTACK_MODIFIER_ID = UUID.fromString("0e13d84c-52ed-4335-a284-49596533f445");
    private static final AttributeModifier HOME_ATTACK_MODIFIER = new AttributeModifier(ATTACK_MODIFIER_ID, "home_attack_modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Integer> GRAB_TIME = SynchedEntityData.m_135353_(LegacyRifter.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final MnEntityDataAccessor<Boolean> FROM_RIFT = new MnEntityDataAccessor("FromRift", SynchedEntityData.m_135353_(LegacyRifter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_));
    public final AnimatableInstanceCache animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public Rift homeRift;
    public int swingTimer;

    public LegacyRifter(EntityType<? extends LegacyRifter> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new RifterMoveControl(this);
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_((Attribute)MnAttributes.MALIGNANT_ARMOR.get(), 3.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GRAB_TIME, (Object)0);
        this.f_19804_.m_135372_(FROM_RIFT, (Object)false);
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setFromRift(compound.m_128471_(FROM_RIFT.getKey()));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_(FROM_RIFT.getKey(), this.isFromRift());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SearchForRiftGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new ReturnToRiftGoal(this, 1.3));
        this.f_21345_.m_25352_(1, (Goal)new CarryToRiftGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            public boolean m_8036_() {
                return super.m_8036_() && !LegacyRifter.this.m_20160_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5, 0.2f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(GRAB_TIME, (Object)(this.m_20160_() ? (Integer)this.f_19804_.m_135370_(GRAB_TIME) + 1 : 0));
            this.applyHomeModifier(Attributes.f_22279_, HOME_SPEED_MODIFIER);
            this.applyHomeModifier(Attributes.f_22281_, HOME_ATTACK_MODIFIER);
            this.applyHomeModifier(Attributes.f_22284_, HOME_ARMOR_MODIFIER);
            if (this.hasHomeRift()) {
                this.m_21446_(this.homeRift.m_20183_(), 15);
            }
            if (!(this.m_21525_() || this.inHomeDim() || this.f_19797_ % 20 != 0 || this.hasHomeRift())) {
                this.m_6469_(this.m_9236_().m_269111_().m_269341_(), 2.0f);
            }
        } else if (this.swingTimer > 0) {
            --this.swingTimer;
        }
    }

    public boolean m_7327_(Entity entity) {
        if (!this.inHomeDim() && this.hasHomeRift()) {
            entity.m_20329_((Entity)this);
        }
        if (!this.m_20160_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)4);
        }
        return super.m_7327_(entity);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity trueSource = source.m_7639_();
        if (super.m_6469_(source, amount)) {
            LivingEntity livingSource;
            if (trueSource instanceof LivingEntity && this.m_6779_(livingSource = (LivingEntity)trueSource) && this.shouldChangeTarget(this.m_5448_(), livingSource)) {
                this.m_6710_(livingSource);
            }
            if (amount > 2.0f) {
                this.m_20153_();
            }
            return true;
        }
        return false;
    }

    private void applyHomeModifier(Attribute attribute, AttributeModifier modifier) {
        AttributeInstance instance = this.m_21051_(attribute);
        boolean home = this.inHomeDim();
        if (home != instance.m_22109_(modifier)) {
            if (home) {
                instance.m_22125_(modifier);
            } else {
                instance.m_22130_(modifier);
            }
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return super.m_6431_(pose, dimensions);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose);
    }

    public float m_6134_() {
        return this.inHomeDim() ? 1.4f : 1.2f;
    }

    public boolean hasHomeRift() {
        return this.homeRift != null && !this.homeRift.m_213877_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animPredicate)});
    }

    private <E extends LegacyRifter> PlayState animPredicate(AnimationState<E> e) {
        AnimationController controller = e.getController();
        if (this.m_20160_()) {
            controller.setAnimation(RawAnimation.begin().thenPlay("GrabStart").thenLoop("Holding"));
        } else if (AnimationHelper.isCurrentlyAnimating((AnimationController<? extends GeoAnimatable>)controller, "Holding", "GrabStop")) {
            controller.setAnimation(RawAnimation.begin().thenPlay("GrabStop").thenLoop("Idle"));
        } else if (this.swingTimer > 0) {
            controller.setAnimation(RawAnimation.begin().thenPlay("Attack").thenLoop("Idle"));
        } else {
            controller.setAnimation(RawAnimation.begin().thenLoop("Idle"));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationFactory;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MnSoundEvents.ENTITY_RIFTER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MnSoundEvents.ENTITY_RIFTER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MnSoundEvents.ENTITY_RIFTER_DEATH.get();
    }

    protected float m_6121_() {
        return 1.3f;
    }

    public boolean inHomeDim() {
        return MnDimensions.THE_MIDNIGHT.is(this.m_9236_());
    }

    public void onAddedToWorld() {
        this.m_6210_();
    }

    public boolean shouldRiderFaceForward(Player player) {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean m_20152_() {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean m_6779_(LivingEntity target) {
        if (target == null || target.m_20201_() instanceof LegacyRifter || target.m_5803_()) {
            return false;
        }
        if (target instanceof Animal) {
            return !this.inHomeDim();
        }
        return super.m_6779_(target);
    }

    private boolean shouldChangeTarget(@Nullable LivingEntity from, LivingEntity to) {
        if (from == null || from.m_213877_()) {
            return true;
        }
        if (to instanceof Player && !(from instanceof Player)) {
            return true;
        }
        return to.m_21223_() > from.m_21223_();
    }

    public boolean m_7307_(Entity entity) {
        if (entity instanceof LegacyRifter) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return super.m_7307_(entity);
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        if (this.m_20363_(passenger)) {
            Vec3 vec = this.holdPosition();
            callback.m_20372_(passenger, vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
        }
    }

    public Vec3 m_7688_(LivingEntity entity) {
        return this.holdPosition();
    }

    private Vec3 holdPosition() {
        float mov = -Mth.m_14089_((float)((2.5f + (float)((Integer)this.f_19804_.m_135370_(GRAB_TIME)).intValue()) * 0.209f)) * 0.05f;
        float dist = (!this.inHomeDim() ? 1.5f : 1.8f) + mov;
        float x = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))) * dist;
        float z = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))) * dist;
        return new Vec3(this.m_20185_() - (double)x, this.m_20186_() + (double)(-mov) + (double)0.2f, this.m_20189_() + (double)z);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        return super.m_6071_(player, hand);
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.swingTimer = 12;
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    public void onEnterRift(Rift rift) {
        this.m_20153_();
        this.m_8127_();
    }

    @Override
    public Rift.TravelEntry createTravelEntry(Rift rift) {
        return new Rift.TravelEntry((LivingEntity)this);
    }

    @Override
    public Collection<Rift.TravelEntry> getAdditionalTravelers(Rift rift) {
        return this.m_20197_().stream().filter(e -> {
            LivingEntity l;
            return e instanceof LivingEntity && !(l = (LivingEntity)e).m_213877_() && l.m_6084_();
        }).map(e -> new Rift.TravelEntry((LivingEntity)e)).toList();
    }

    public Rift getHomeRift() {
        return this.homeRift;
    }

    private boolean hasCaptured() {
        return this.m_20160_() && this.hasHomeRift();
    }

    public boolean isFromRift() {
        return (Boolean)this.f_19804_.m_135370_(FROM_RIFT);
    }

    public void setFromRift(boolean flag) {
        this.f_19804_.m_135381_(FROM_RIFT, (Object)flag);
    }

    public MobType m_6336_() {
        return MnEntityTypes.CORRUPTED;
    }

    public class RifterMoveControl
    extends MoveControl {
        private final LegacyRifter rifter;

        public RifterMoveControl(LegacyRifter mob) {
            super((Mob)mob);
            this.rifter = mob;
        }

        public void m_8126_() {
            super.m_8126_();
            if (this.rifter.hasCaptured()) {
                this.rifter.m_21564_(-this.rifter.f_20902_);
            }
        }

        protected float m_24991_(float sourceAngle, float targetAngle, float maximumChange) {
            return super.m_24991_(sourceAngle, targetAngle + (float)(this.rifter.hasCaptured() ? 180 : 0), maximumChange);
        }
    }

    public class SearchForRiftGoal
    extends Goal {
        protected final LegacyRifter owner;

        public SearchForRiftGoal(LegacyRifter owner) {
            this.owner = owner;
        }

        public boolean m_8036_() {
            return !this.owner.inHomeDim() && !this.owner.hasHomeRift() && this.owner.isFromRift();
        }

        public void m_8056_() {
            Optional<Rift> rift = this.owner.m_9236_().m_6249_((Entity)null, this.owner.m_20191_().m_82377_(20.0, 10.0, 20.0), e -> e instanceof Rift).stream().map(e -> (Rift)e).findFirst();
            if (rift.isPresent()) {
                this.owner.homeRift = rift.get();
            }
        }
    }

    public class ReturnToRiftGoal
    extends Goal {
        protected static final int RETURN_EARLY_TIME = 80;
        protected static final int INVALIDATE_TIME = 20;
        protected final LegacyRifter owner;
        protected final double returnSpeed;
        protected int invalidCount = 0;
        protected Path path;

        public ReturnToRiftGoal(LegacyRifter owner, double returnSpeed) {
            this.owner = owner;
            this.returnSpeed = returnSpeed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return this.shouldReturn();
        }

        public boolean m_8045_() {
            return this.shouldReturn() && this.invalidCount <= 20;
        }

        public boolean shouldReturn() {
            if (this.owner.inHomeDim() || !this.owner.hasHomeRift()) {
                return false;
            }
            Rift homeRift = this.owner.getHomeRift();
            return homeRift.getBridge().getTimeUntilClose() < 80;
        }

        public void m_8056_() {
            this.path = this.computeFollowPath();
            this.owner.m_21573_().m_26536_(this.path, this.returnSpeed);
        }

        public void m_8037_() {
            int n;
            Path targetPath = this.computeFollowPath();
            if (targetPath == null) {
                this.path = null;
                return;
            }
            Path currentPath = this.owner.m_21573_().m_26570_();
            if (currentPath != targetPath) {
                this.owner.m_21573_().m_26536_(targetPath, this.returnSpeed);
            }
            if (this.path == null) {
                int n2 = this.invalidCount;
                n = n2;
                this.invalidCount = n2 + 1;
            } else {
                n = 0;
            }
            this.invalidCount = n;
        }

        @Nullable
        private Path computeFollowPath() {
            if (this.isPathComplete(this.path)) {
                this.path = null;
                this.invalidCount = 0;
            }
            if (this.path == null) {
                this.owner.m_21573_().m_26573_();
                if (this.owner.hasHomeRift()) {
                    Rift homeRift = this.owner.getHomeRift();
                    BlockPos surface = homeRift.m_20183_();
                    this.path = this.owner.m_21573_().m_7864_(surface, 0);
                    if (this.path == null) {
                        this.path = this.computePathTowards(surface);
                    }
                }
            }
            return this.path;
        }

        @Nullable
        private Path computePathTowards(BlockPos surface) {
            Vec3 target = Vec3.m_82539_((Vec3i)surface);
            for (int i = 0; i < 16; ++i) {
                Path path;
                Vec3 pathPos = LandRandomPos.m_148492_((PathfinderMob)this.owner, (int)24, (int)4, (Vec3)target);
                if (pathPos == null || (path = this.owner.m_21573_().m_26524_(pathPos.f_82479_, pathPos.f_82480_, pathPos.f_82481_, 0)) == null) continue;
                return path;
            }
            return null;
        }

        private boolean isPathComplete(Path path) {
            if (path == null || path.m_77392_()) {
                return true;
            }
            Node finalPoint = path.m_77395_();
            return finalPoint == null || this.owner.m_20275_(finalPoint.f_77271_, finalPoint.f_77272_, finalPoint.f_77273_) < 2.25;
        }

        public void m_8041_() {
            this.owner.m_21573_().m_26573_();
            this.path = null;
            this.invalidCount = 0;
        }
    }

    public class CarryToRiftGoal
    extends Goal {
        protected final LegacyRifter owner;
        protected final double returnSpeed;

        public CarryToRiftGoal(LegacyRifter owner, double returnSpeed) {
            this.owner = owner;
            this.returnSpeed = returnSpeed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return !this.owner.inHomeDim() && this.owner.hasHomeRift() && this.owner.m_20160_();
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8037_() {
            Rift rift = this.owner.homeRift;
            if (this.owner.m_20270_(rift) < 2.0f) {
                this.owner.f_21344_.m_26573_();
                this.owner.f_21342_.m_6849_(rift.m_20185_(), rift.m_20186_(), rift.m_20189_(), this.returnSpeed);
            } else {
                this.owner.f_21344_.m_26519_(rift.m_20185_(), rift.m_20186_(), rift.m_20189_(), this.returnSpeed);
            }
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }
}

