/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.creature.animal;

import com.crypticmushroom.minecraft.midnight.common.entity.animation.AnimationHelper;
import com.crypticmushroom.minecraft.midnight.common.entity.network.MnEntityDataAccessor;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FleeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRetaliateTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SlinkEntity
extends Animal
implements GeoEntity,
SmartBrainOwner<SlinkEntity> {
    private static final MnEntityDataAccessor<Boolean> STEALTH = new MnEntityDataAccessor("Stealth", SynchedEntityData.m_135353_(SlinkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_));
    private final AnimatableInstanceCache animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int stealthCooldown = 0;

    public SlinkEntity(EntityType<? extends SlinkEntity> entityType, Level level) {
        super(entityType, level);
        Arrays.fill(this.f_21347_, 1.0f);
        Arrays.fill(this.f_21348_, 1.0f);
        this.f_21364_ = 4;
    }

    public static AttributeSupplier.Builder attributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 8.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        this.setStealth(true);
        return data;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STEALTH, (Object)false);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController<SlinkEntity>(this, "controller", 0, this::animate){
            {
                this.transitionLength(8);
                this.setAnimation(RawAnimation.begin().thenLoop("Idle"));
            }
        }});
    }

    private PlayState animate(AnimationState<SlinkEntity> event) {
        AnimationController controller = event.getController();
        String walkAnim = "Walk";
        if (event.isMoving()) {
            if (!AnimationHelper.isCurrentlyAnimating((AnimationController<? extends GeoAnimatable>)controller, "Walk")) {
                controller.setAnimation(RawAnimation.begin().thenLoop("Walk"));
                controller.setAnimationSpeed(2.0);
            } else if (AnimationHelper.isCurrentlyAnimating((AnimationController<? extends GeoAnimatable>)controller, "Walk")) {
                controller.setAnimationSpeed((double)(event.getLimbSwingAmount() * 2.0f));
            }
        } else {
            if (!AnimationHelper.isCurrentlyAnimating((AnimationController<? extends GeoAnimatable>)controller, "Idle")) {
                controller.setAnimation(RawAnimation.begin().thenLoop("Idle"));
            }
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationFactory;
    }

    protected Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<SlinkEntity>> getSensors() {
        return List.of(new HurtBySensor(), new NearbyLivingEntitySensor());
    }

    public BrainActivityGroup<SlinkEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new FloatToSurfaceOfFluid(), new FleeTarget().speedModifier(2.5f), new LookAtTarget<SlinkEntity>(){

            protected void start(SlinkEntity entity) {
                EntityTracker entityTracker;
                PositionTracker lookingAt = (PositionTracker)BrainUtils.getMemory((LivingEntity)SlinkEntity.this, (MemoryModuleType)MemoryModuleType.f_26371_);
                if (!(lookingAt == null || lookingAt instanceof EntityTracker && (entityTracker = (EntityTracker)lookingAt).m_147481_() instanceof Player)) {
                    SlinkEntity.this.stealthIfPossible();
                }
                super.start((LivingEntity)entity);
            }
        }, new MoveToWalkTarget<SlinkEntity>(){

            protected void start(SlinkEntity entity) {
                SlinkEntity.this.stealthIfPossible();
                super.start((PathfinderMob)entity);
            }
        }});
    }

    public BrainActivityGroup<SlinkEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetRetaliateTarget(), new SetPlayerLookTarget(), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget(), new Idle().runFor(entity -> entity.m_217043_().m_216339_(30, 60))})});
    }

    public BrainActivityGroup<SlinkEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((slink, target) -> {
            Player pl;
            return !target.m_6084_() || target.m_20280_((Entity)this) > 225.0 || target instanceof Player && ((pl = (Player)target).m_7500_() || pl.m_5833_());
        })});
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob offspring) {
        return null;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        return this.m_20183_().m_123342_() > level.m_5736_() && super.m_5545_(level, spawnReason);
    }

    private boolean canStealth() {
        return this.stealthCooldown <= 0;
    }

    public void stealthIfPossible() {
        if (this.canStealth()) {
            this.setStealth(true);
        }
    }

    public void setStealth(boolean stealth) {
        this.f_19804_.m_135381_(STEALTH, (Object)stealth);
        this.stealthCooldown = 60;
    }

    public boolean isStealth() {
        return (Boolean)this.f_19804_.m_135370_(STEALTH);
    }

    public boolean m_7327_(Entity entity) {
        this.setStealth(false);
        return super.m_7327_(entity);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.stealthCooldown > 0) {
            --this.stealthCooldown;
        }
    }

    public float m_6113_() {
        return super.m_6113_() * (this.isStealth() ? 0.3f : 1.0f);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_(STEALTH.getKey(), this.isStealth());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setStealth(compound.m_128471_(STEALTH.getKey()));
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public int m_8100_() {
        return 100;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MnSoundEvents.ENTITY_SLINK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MnSoundEvents.ENTITY_SLINK_DEATH.get();
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos.m_7495_()).m_60734_() == MnBlocks.NIGHT_GRASS_BLOCK.get() ? 10.0f : 1.0f;
    }
}

