/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.ai.goal;

import com.crypticmushroom.minecraft.midnight.common.util.MathUtil;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.Vec3;

public class FindFoodGoal
extends Goal {
    private static final byte ITEM_EATEN_ENTITY_EVENT = 45;
    private final Mob mob;
    private final Ingredient ingredient;
    protected final float speedModifier;
    private final double radius;
    private final float chance;
    private ItemEntity target;
    private int eatTicks;

    public FindFoodGoal(Mob mob, Ingredient ingredient, float speedModifier, double radius, float chance) {
        this.mob = mob;
        this.ingredient = ingredient;
        this.speedModifier = speedModifier;
        this.radius = radius;
        this.chance = chance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        TamableAnimal tamed;
        Mob mob;
        boolean shouldNotUse = !this.mob.m_6084_() || (mob = this.mob) instanceof TamableAnimal && (tamed = (TamableAnimal)mob).m_21824_() || this.mob.m_5448_() != null || !MathUtil.chanceMet(this.mob.m_217043_(), this.chance);
        return !shouldNotUse && !this.getNearbyItemEntities().isEmpty();
    }

    private List<ItemEntity> getNearbyItemEntities() {
        return this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82400_(this.radius), this::canPickUp);
    }

    private boolean canPickUp(ItemEntity item) {
        return !item.m_32063_() && item.m_6084_() && this.canEatItem(item.m_32055_());
    }

    private boolean canEatItem(ItemStack item) {
        return this.ingredient.test(item);
    }

    public boolean m_8045_() {
        return this.target != null;
    }

    public void m_8056_() {
        this.target = this.getNearbyItemEntities().get(0);
        this.m_8037_();
    }

    public void m_8037_() {
        if (!this.mob.m_21573_().m_5624_((Entity)this.target, (double)this.speedModifier)) {
            this.target = null;
        }
    }

    private ItemStack getHeldItem() {
        return this.mob.m_6844_(EquipmentSlot.MAINHAND);
    }

    private void setHeldItem(ItemStack item) {
        this.mob.m_8061_(EquipmentSlot.MAINHAND, item);
    }

    public void customServerAiStep() {
        if (this.mob.m_6084_()) {
            ++this.eatTicks;
            ItemStack item = this.getHeldItem();
            if (this.canEatItem(item) && this.eatTicks > 200) {
                ItemStack used = item.m_41671_(this.mob.m_9236_(), (LivingEntity)this.mob);
                if (!used.m_41619_()) {
                    this.setHeldItem(used);
                }
                this.mob.m_5634_(2.0f);
                this.eatTicks = 0;
                this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)45);
            }
        }
    }

    public void handleEntityEvent(byte id) {
        if (id != 45) {
            return;
        }
        ItemStack item = this.getHeldItem();
        this.mob.m_216990_(this.mob.m_7866_(item));
        if (!item.m_41619_()) {
            this.spawnParticles(item);
        }
    }

    private void spawnParticles(ItemStack item) {
        for (int i = 0; i < 8; ++i) {
            Vec3 vec3d = MathUtil.rotatePitchAndYaw(new Vec3(((double)this.mob.m_217043_().m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0), -this.mob.f_20885_ * ((float)Math.PI / 180), -this.mob.f_20886_ * ((float)Math.PI / 180));
            this.mob.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, item), this.mob.m_20185_() + this.mob.m_20154_().f_82479_ / 2.0, this.mob.m_20186_(), this.mob.m_20189_() + this.mob.m_20154_().f_82481_ / 2.0, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
        }
    }

    public boolean canReplaceCurrentItem(ItemStack candidate, ItemStack existing) {
        return !this.canEatItem(existing) && this.canEatItem(candidate);
    }

    public void onItemPickup(ItemEntity itemEntity) {
        this.spitOutItem(this.getHeldItem());
        this.eatTicks = 0;
    }

    private void spitOutItem(ItemStack item) {
        if (!item.m_41619_() && !this.mob.m_9236_().f_46443_) {
            ItemEntity itemEntity = new ItemEntity(this.mob.m_9236_(), this.mob.m_20185_() + this.mob.m_20154_().f_82479_, this.mob.m_20186_() + 1.0, this.mob.m_20189_() + this.mob.m_20154_().f_82481_, item);
            itemEntity.m_32010_(40);
            itemEntity.m_32052_(this.mob.m_20148_());
            this.mob.m_9236_().m_7967_((Entity)itemEntity);
        }
    }
}

