/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.behaviour;

import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.util.BrainUtils;

public class TargetRideAttack<E extends Mob>
extends AnimatableMeleeAttack<E> {
    protected BiPredicate<E, LivingEntity> isTargetValid = (entity, target) -> true;
    protected BiConsumer<E, LivingEntity> onSuccessCallback = (entity, target) -> {};

    public TargetRideAttack(int delayTicks) {
        super(delayTicks);
    }

    public final TargetRideAttack<E> targetValidIf(BiPredicate<E, LivingEntity> predicate) {
        this.isTargetValid = predicate;
        return this;
    }

    public final TargetRideAttack<E> whenSuccessful(BiConsumer<E, LivingEntity> callback) {
        this.onSuccessCallback = callback;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return super.checkExtraStartConditions(level, entity) && this.isTargetValid.test(entity, this.target);
    }

    protected void doDelayedAction(E entity) {
        BrainUtils.setForgettableMemory(entity, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)((Integer)this.attackIntervalSupplier.apply(entity)));
        if (this.target == null) {
            return;
        }
        if (!entity.m_21574_().m_148306_((Entity)this.target) || !entity.m_217066_(this.target) && !this.isTargetValid.test(entity, this.target)) {
            return;
        }
        this.target.m_20329_(entity);
        if (!entity.m_20160_()) {
            entity.m_9236_().m_7605_(entity, (byte)4);
        }
        this.onSuccessCallback.accept(entity, this.target);
    }
}

