/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.behaviour;

import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.registry.MnMemoryTypes;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class SetRandomWalkTargetNearRift<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)((MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get()), (Object)MemoryStatus.VALUE_PRESENT)});
    protected SquareRadius radius = new SquareRadius(10.0, 7.0);
    protected BiFunction<E, Vec3, Float> speedModifier = (entity, targetPos) -> Float.valueOf(1.0f);
    protected Predicate<E> avoidWaterPredicate = entity -> true;
    protected BiPredicate<E, Vec3> positionPredicate = (entity, pos) -> true;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public SetRandomWalkTargetNearRift<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public SetRandomWalkTargetNearRift<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    public SetRandomWalkTargetNearRift<E> speedModifier(float modifier) {
        return this.speedModifier((entity, targetPos) -> Float.valueOf(modifier));
    }

    public SetRandomWalkTargetNearRift<E> speedModifier(BiFunction<E, Vec3, Float> function) {
        this.speedModifier = function;
        return this;
    }

    public SetRandomWalkTargetNearRift<E> walkTargetPredicate(BiPredicate<E, Vec3> predicate) {
        this.positionPredicate = predicate;
        return this;
    }

    public SetRandomWalkTargetNearRift<E> dontAvoidWater() {
        return this.avoidWaterWhen(entity -> false);
    }

    public SetRandomWalkTargetNearRift<E> avoidWaterWhen(Predicate<E> predicate) {
        this.avoidWaterPredicate = predicate;
        return this;
    }

    protected void start(E entity) {
        List nearbyRifts = (List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get()));
        Rift rift = (Rift)nearbyRifts.get(entity.m_217043_().m_188503_(nearbyRifts.size()));
        BlockPos riftPos = rift.m_20183_();
        Vec3 targetPos = this.getTargetPos(entity, riftPos);
        if (!this.positionPredicate.test(entity, targetPos)) {
            targetPos = null;
        }
        if (targetPos == null) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
        } else {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget(targetPos, this.speedModifier.apply(entity, targetPos).floatValue(), 0));
        }
    }

    @Nullable
    protected Vec3 getTargetPos(E entity, BlockPos riftPos) {
        if (this.avoidWaterPredicate.test(entity)) {
            return SetRandomWalkTargetNearRift.getLandPos(entity, riftPos, (int)this.radius.xzRadius(), (int)this.radius.yRadius(), arg_0 -> entity.m_21692_(arg_0));
        }
        return SetRandomWalkTargetNearRift.getDefaultPos(entity, riftPos, (int)this.radius.xzRadius(), (int)this.radius.yRadius());
    }

    @javax.annotation.Nullable
    public static Vec3 getLandPos(PathfinderMob mob, BlockPos riftPos, int radius, int yRange, ToDoubleFunction<BlockPos> toDoubleFunction) {
        boolean restricted = GoalUtils.m_148442_((PathfinderMob)mob, (int)radius);
        return RandomPos.m_148561_(() -> {
            BlockPos moveVector = RandomPos.m_217851_((RandomSource)mob.m_217043_(), (int)radius, (int)yRange).m_121955_((Vec3i)riftPos.m_121996_((Vec3i)mob.m_20183_()));
            BlockPos pos = LandRandomPos.m_148513_((PathfinderMob)mob, (int)radius, (boolean)restricted, (BlockPos)moveVector);
            return pos == null ? null : LandRandomPos.m_148518_((PathfinderMob)mob, (BlockPos)pos);
        }, toDoubleFunction);
    }

    @javax.annotation.Nullable
    public static Vec3 getDefaultPos(PathfinderMob mob, BlockPos riftPos, int radius, int verticalDistance) {
        boolean restricted = GoalUtils.m_148442_((PathfinderMob)mob, (int)radius);
        return RandomPos.m_148542_((PathfinderMob)mob, () -> {
            BlockPos pos = RandomPos.m_217851_((RandomSource)mob.m_217043_(), (int)radius, (int)verticalDistance).m_121955_((Vec3i)riftPos.m_121996_((Vec3i)mob.m_20183_()));
            return SetRandomWalkTargetNearRift.generateRandomPosTowardDirection(mob, radius, restricted, pos);
        });
    }

    @javax.annotation.Nullable
    private static BlockPos generateRandomPosTowardDirection(PathfinderMob mob, int radius, boolean shortCircuit, BlockPos pos) {
        BlockPos blockpos = RandomPos.m_217863_((PathfinderMob)mob, (int)radius, (RandomSource)mob.m_217043_(), (BlockPos)pos);
        return !GoalUtils.m_148451_((BlockPos)blockpos, (PathfinderMob)mob) && !GoalUtils.m_148454_((boolean)shortCircuit, (PathfinderMob)mob, (BlockPos)blockpos) && !GoalUtils.m_148448_((PathNavigation)mob.m_21573_(), (BlockPos)blockpos) && !GoalUtils.m_148458_((PathfinderMob)mob, (BlockPos)blockpos) ? blockpos : null;
    }
}

