/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.GroupBehaviour;
import net.tslat.smartbrainlib.object.SBLShufflingList;
import org.jetbrains.annotations.Nullable;

public final class ContinuousSequentialBehaviour<E extends LivingEntity>
extends GroupBehaviour<E> {
    private Predicate<ExtendedBehaviour<? super E>> earlyResetPredicate = behaviour -> false;
    private ExtendedBehaviour<? super E> lastRun = null;

    public ContinuousSequentialBehaviour(Pair<ExtendedBehaviour<? super E>, Integer> ... behaviours) {
        super(behaviours);
    }

    public ContinuousSequentialBehaviour(ExtendedBehaviour<? super E> ... behaviours) {
        super(behaviours);
    }

    public ContinuousSequentialBehaviour<E> resetIf(Predicate<ExtendedBehaviour<? super E>> predicate) {
        this.earlyResetPredicate = predicate;
        return this;
    }

    @Nullable
    protected ExtendedBehaviour<? super E> pickBehaviour(ServerLevel level, E entity, long gameTime, SBLShufflingList<ExtendedBehaviour<? super E>> extendedBehaviours) {
        boolean pickNext;
        boolean bl = pickNext = this.lastRun == null;
        if (this.lastRun != null && this.earlyResetPredicate.test(this.lastRun)) {
            pickNext = true;
            this.lastRun = null;
        }
        for (ExtendedBehaviour behaviour : extendedBehaviours) {
            if (pickNext) {
                behaviour.m_22554_(level, entity, gameTime);
                this.lastRun = behaviour;
                return behaviour;
            }
            if (behaviour != this.lastRun) continue;
            pickNext = true;
        }
        this.lastRun = null;
        return null;
    }
}

