/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.capability.entity;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.block.UmbraflameBlock;
import com.crypticmushroom.minecraft.midnight.common.capability.CapabilityProvider;
import com.crypticmushroom.minecraft.midnight.common.capability.IPersistentCapability;
import com.crypticmushroom.minecraft.midnight.common.capability.ISyncedCapability;
import com.crypticmushroom.minecraft.midnight.common.capability.entity.BaseMnEntity;
import com.crypticmushroom.minecraft.midnight.common.network.MnNetwork;
import com.crypticmushroom.minecraft.midnight.common.network.capability.MnEntityPacket;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.network.PacketDistributor;

public final class MnEntity
implements BaseMnEntity<Entity>,
IPersistentCapability<MnEntity>,
ISyncedCapability {
    public static final Capability<MnEntity> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<MnEntity>(){});
    private final Entity entity;
    private boolean umbraflameDamage = false;
    private static final String UMBRAFLAME_KEY = "UmbraflameDamage";

    public static void attach(AttachCapabilitiesEvent<? extends Entity> event) {
        event.addCapability(Midnight.id("entity"), new CapabilityProvider<MnEntity>(new MnEntity((Entity)event.getObject())));
    }

    private MnEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    public void clientTick() {
    }

    public void serverTick() {
        if (this.isTakingUmbraflameDamage() && !this.getEntity().m_6060_() && !UmbraflameBlock.isEntityInside(this.getEntity())) {
            this.setTakingUmbraflameDamage(false);
        }
    }

    public boolean isTakingUmbraflameDamage() {
        return this.umbraflameDamage;
    }

    public void setTakingUmbraflameDamage(boolean isTakingUmbraflameDamage) {
        if (this.umbraflameDamage == isTakingUmbraflameDamage) {
            return;
        }
        this.umbraflameDamage = isTakingUmbraflameDamage;
        this.syncDataToClient();
    }

    public void applyUmbraflameEffects(int ticks) {
        Entity entity = this.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.isTakingUmbraflameDamage()) {
                MobEffectInstance effect = new MobEffectInstance(MobEffects.f_216964_, ticks, 9, false, false, true);
                livingEntity.m_7292_(effect);
            }
        }
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128379_(UMBRAFLAME_KEY, this.isTakingUmbraflameDamage());
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        this.umbraflameDamage = tag.m_128471_(UMBRAFLAME_KEY);
    }

    @Override
    public void syncDataToClient() {
        if (this.getEntity().m_9236_().f_46443_) {
            return;
        }
        MnEntityPacket packet = new MnEntityPacket(this);
        MnNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getEntity), (Object)packet);
    }

    @Override
    public Capability<MnEntity> getDefaultInstance() {
        return INSTANCE;
    }

    public static <E extends Entity> boolean isPresent(E entity) {
        if (entity == null) {
            return false;
        }
        return entity.getCapability(INSTANCE).resolve().isPresent();
    }

    public static <E extends Entity> void ifPresent(E entity, Consumer<MnEntity> action) {
        if (entity == null) {
            return;
        }
        entity.getCapability(INSTANCE).resolve().ifPresent(action);
    }

    public static <E extends Entity, R> R getIfPresent(E entity, Function<MnEntity, R> action, Supplier<R> orElse) {
        Optional capability;
        if (entity != null && (capability = entity.getCapability(INSTANCE).resolve()).isPresent()) {
            return action.apply((MnEntity)capability.get());
        }
        return orElse.get();
    }
}

