/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block.plant;

import com.crypticmushroom.minecraft.midnight.common.block.plant.CustomPlaceableBush;
import com.crypticmushroom.minecraft.midnight.common.block.util.MnBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class UpwardBushBlock
extends BushBlock
implements CustomPlaceableBush {
    public static final BooleanProperty ROOT = MnBlockStateProperties.ROOT;
    public static final BooleanProperty END = MnBlockStateProperties.END;
    private final VoxelShape stemShape;
    private final VoxelShape endShape;
    private final TagKey<Block> plantableBlocks;
    private final boolean requireSolidFace;

    public UpwardBushBlock(BlockBehaviour.Properties properties, TagKey<Block> plantableBlocks, boolean requireSolidFace, VoxelShape stemShape, VoxelShape endShape) {
        super(properties);
        this.stemShape = stemShape;
        this.endShape = endShape;
        this.plantableBlocks = plantableBlocks;
        this.requireSolidFace = requireSolidFace;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROOT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)END, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public TagKey<Block> getPlantableBlocks() {
        return this.plantableBlocks;
    }

    @Override
    public boolean requiresSolidFace() {
        return this.requireSolidFace;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ROOT, END});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60713_((Block)this) || super.m_7898_(state, level, pos);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!this.m_7898_(state, (LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return this.updateRootEnd(state, (BlockGetter)level, currentPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.updateRootEnd(this.m_49966_(), (BlockGetter)context.m_43725_(), context.m_8083_());
    }

    protected BlockState updateRootEnd(BlockState state, BlockGetter level, BlockPos pos) {
        BlockPos down = pos.m_7495_();
        BlockState stateDown = level.m_8055_(down);
        boolean root = !stateDown.m_60713_((Block)this) && !stateDown.m_60795_();
        boolean end = !level.m_8055_(pos.m_7494_()).m_60713_((Block)this);
        return (BlockState)((BlockState)state.m_61124_((Property)ROOT, (Comparable)Boolean.valueOf(root))).m_61124_((Property)END, (Comparable)Boolean.valueOf(end));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
        super.m_213897_(state, level, pos, random);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)END) != false ? this.endShape : this.stemShape;
    }
}

